var mysql = require('mysql');
var async = require('async');
var fs = require('fs');

var connection = mysql.createPool({
  "host": "127.0.0.1",
  "user": "root",
  "password": "bla",
  "database": "zip"
});

async.series({
  holiday: function (cb) {
    connection.query("SELECT plz, gemeindename, feiertag FROM relHoliday", function(err, res) {
      cb(err, res);
    });
  }
}, function(err, res) {
  if(err) return console.error(err);
  aggregateTables(res);
})


function aggregateTables(tables) {
  var zipMap = {};
  var holidays = tables.holiday;

  holidays = holidays.sort(function (a, b) {
    return a.plz - b.plz;
  });

  holidays.forEach(function (h) {
    var plz = h.plz;
    if(plz in zipMap) {
      zipMap[plz].push({
        name: h.gemeindename,
        holiday: h.feiertag
      })
    }
    else {
      zipMap[plz] = [{
        name: h.gemeindename,
        holiday: h.feiertag
      }]
    }
  });

  console.log(zipMap);
  fs.writeFileSync("kathHolidays.json", JSON.stringify(zipMap, null, "  "));

  connection.end();
}