module.exports = function (config) {
  var _config = require('./config.json');
  if (config) _config["mysqlConfig"] = config;

  var dateArray = require('./lib/dateArray');
  var dateView = require('./lib/dateView');

  function getOHIndex(incl, excl, maybe, today, plz, cb) {
    today = new Date(today.getFullYear(), today.getMonth(), today.getDate());
    var tomorrow = new Date(today.getFullYear(), today.getMonth(), today.getDate() + 1);

    var epochSpan = [new Date(today.getFullYear(), today.getMonth(), today.getDate() - 7),
      new Date(today.getFullYear(), today.getMonth(), today.getDate() + 2)];
    dateArray(epochSpan).getData([incl, excl, maybe], plz, function (err, result) {
      if (err) return cb(err);
      var resultSure = result.intervals;
      var resultMaybe = result.maybeIntervals;

      var fResult = {
        sure: resultSure.filter(function (elem) {
          return elem[0].getTime() >= today.getTime();
        }),
        maybe: resultMaybe.filter(function (elem) {
          return elem[0].getTime() >= today.getTime();
        }),
        sureToday: resultSure.filter(function (elem) {
          return elem[0].getTime() >= today.getTime() && elem[1].getTime() <= tomorrow.getTime();
        }),
        maybeToday: resultMaybe.filter(function (elem) {
          return elem[0].getTime() >= today.getTime() && elem[1].getTime() <= tomorrow.getTime();
        }),
        debugInfo: result.debugInfo
      };

      cb(null, fResult);
    })
  }

  return {
    getOHIndex: getOHIndex,
    dateArray: dateArray,
    dateView: dateView
  }
};
