var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');
var async = require('async');

//var data = ['{"state":"Bayern","zip":"94152","religiousHoliday":true,"data":{"include":[{"option":{"0":"default"},"dayoption":{"0":"4"},"repeatoption":{"0":""},"holidayoption":{"0":""},"opening_day_from":"","opening_day_to":"","opening_from":"10:00","opening_to":"17:00"},{"option":{"0":"default"},"dayoption":{"0":"5"},"repeatoption":{"0":""},"holidayoption":{"0":""},"opening_day_from":"","opening_day_to":"","opening_from":"14:30","opening_to":"17:00"}],"exlcude":[{"option":{"0":""},"dayoption":{"0":""},"repeatoption":{"0":""},"holidayoption":{"0":""},"opening_day_from":"","opening_day_to":"","opening_from":"","opening_to":""}],"maybe":[{"option":{"0":"default"},"dayoption":{"0":"8"},"repeatoption":{"0":""},"holidayoption":{"0":""},"opening_day_from":"","opening_day_to":"","opening_from":"08:00","opening_to":"20:00"}]}}'];
//data = data.map(JSON.parse);

var ohoursMap = require("./ohours.json");
var data = Object.keys(ohoursMap).map(function (key) {
  var obj = ohoursMap[key];
  obj.id = key;
  return obj;
});

data = data.filter(function (e) {
  return e.name.match(/Preuschl Alfred/i);
});

console.log(data.length);
var getData = module.exports.getData = function (now, cb) {
  now = new Date("Tue Jun 02 2015 17:55:56 GMT+0200 (CEST)");
  var epocheSpan = dateView.getPropperEpochSpan(now);

  async.map(data, function (datum, cb) {
    dateArray(epocheSpan).getData(datum, function (err, dataObj) {
      if (err) {
        console.error(datum.name, err.stack);
        return cb(null, "");
      }

      var view = dateView.getView(dataObj, now);
      var asString = dateView.asString(dataObj, now);
      var text = asString.text.join(", ");
      text = asString.status + " " + text;
      var res = ('<div class="name">' + datum.name  + "</div> " + text + view);
      cb(null, res);
    })
  }, function (err, res) {
    if(err) return cb(err);
    cb(null, res.join('<br><br><br><br><br><br>'));
  })
};

//getData(new Date(), function (err, res) {
//  if(err) return console.error(err);
//});