var mysql = require('mysql');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');

var fs = require('fs');
var tmUtils = require('../lib/timeUtils');

var includeString = "810a6deb-46f2-4fa8-b779-bb5c2a6b5577";
var excludeString = "bb74c170-b06f-4d2b-ab88-2f6bf9ce8068";


var connection = mysql.createConnection({
  host: 'localhost',
  user: 'read',
  password: 'read',
  database: 'regiostart'
});

connection.connect();

connection.query('SELECT name, elements FROM cms_zoo_item WHERE type = "company"', function(err, rows) {
  var cntGood = 0;
  var cntBad = 0;
  for (var i = 0; i < rows.length; i++) {
    var json = rows[i].elements;
    var obj = JSON.parse(json);
    var name = rows[i].name;
    try{
      var result = dateArray.getData(obj);
      tmUtils.validate(result);
    }
    catch(err)
    {
      console.log(err.message, name);
      var result = [];
      fs.writeFileSync(process.env["HOME"] + '/Desktop/oHours/invalid' + name + '.json', json);
    }

    if(result.length > 0) {
//      console.log(name);
//      console.log(JSON.stringify(result));
      cntGood++;
    }
    else {
      cntBad++;
    }
  }
  console.log(cntGood, cntBad);
});

connection.end();