var dateArray = require('./dateArray');
var moment = require('moment');

moment.lang("de");


function createWeekView(data, now) {
  var noOfDays = 7;
  var offset = 3;
  var startDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() - offset);
  var endDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() + noOfDays - offset);
  var oHours = transformData(data, startDate, endDate);
  var maxNumber = getMaxNoOfItemsPerDay(oHours);
  var tableWidth = 2 * maxNumber;

  var content = '<div class="weekview-container"><table class="weekview-table">';
  content += '<tbody>';

  for (var i = 0; i < noOfDays; i++) {
    var day = oHours[i];
    content += '<tr class="weekview-tr">';
    content += '<td class="weekview-td-first">' + formatDate(day.date) + '</td>';

    for (var j = 0; j < day.oHours.length; j++) {
      var oHour = day.oHours[j];
      content += '<td class="weekview-td weekview-filled">' + formatTime(oHour[0]) + '</td>';
      content += '<td class="weekview-td weekview-filled">' + formatTime(oHour[1]) + '</td>';
    }
    for (var j = 2 * day.oHours.length; j < tableWidth; j++) {
      content += '<td class="weekview-td weekview-empty"></td>';
    }
    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}

function createMonthView(data, now, monthOffset) {
  var currentMonth = now.getMonth() + monthOffset;
  var startDate = new Date(now.getFullYear(), currentMonth, 1);
  var monthDate = new Date(startDate);

  startDate.setDate(2 - startDate.getDay());

  var endDate = new Date(now.getFullYear(), currentMonth + 1, 1);
  if (endDate.getDay() != 1)
    endDate.setDate(9 - endDate.getDay());

  var oHours = transformData(data, startDate, endDate);

  var content = '<div class="monthview-maindiv">';
  content += '<div class="monthview-month">' + moment(monthDate).format("MMMM") + '</div>';
  content += '<table class="monthview-table"><thead class="monthview-thead"><tr>';

  for (var i = 0; i < 7; i++) {
    content += '<th class="monthview-th">' + moment(oHours[i].date).format("dd") + '</th>';
  }
  content += '</tr></thead>';

  for (var i = 0; i < oHours.length; i++) {
    var day = oHours[i];

    if (i % 7 == 0)
      content += '<tr class="monthview-tr">';

    if (day.date.getMonth() == currentMonth) {
      var cls;
      var tooltip;
      if (day.oHours.length == 0) {
        tooltip = "";
        cls = " monthview-empty";
      }
      else {
        cls = " monthview-filled";
        tooltip = [];
        for (var j = 0; j < day.oHours.length; j++) {
          var e = day.oHours[j];
          tooltip.push(formatTime(e[0]) + " - " + formatTime(e[1]));
        }
        tooltip = tooltip.join("<br>");
        tooltip = ' data-uk-tooltip title="' + tooltip + '"';
      }

      content += '<td class="monthview-td' + cls + '"' + tooltip + '>' + moment(day.date).format("D") + '</td>';
    }
    else {
      content += '<td class="monthview-td monthview-exclude"></td>';
    }

    if (i % 7 == 6)
      content += '</tr>';
  }

  content += '</table></div>';
  return content;
}

function create3MonthView(data, now) {
  var content = '<div class="monthview-container">';
  for (var i = 0; i < 3; i++) {
    content += createMonthView(data, now, i);
  }
  content += '</div>';
  return content;
}

function getView(data, now) {
  var content = '<div class="view-container">';
  content += createWeekView(data, now);
  content += create3MonthView(data, now);
  content += '</div>';
  return content;
}

function getMaxNoOfItemsPerDay(oHours) {
  var max = 0;
  for (var i = 0; i < oHours.length; i++) {
    if (oHours[i].oHours.length > max)
      max = oHours[i].oHours.length
  }
  return max;
}

function formatDate(date) {
  return moment(date).format("dd L");
}

function formatTime(date) {
  return moment(date).format("HH:mm");
}

function transformData(data, startDate, endDate) {
  var dataIdx = 0;
  var result = [];
  var curDate = new Date(startDate);
  while (compareDate(curDate, endDate) < 0) {
    var oHours = [];
    while (dataIdx < data.length) {
      var comp = compareDate(data[dataIdx][0], curDate);
      if (comp < 0)
        dataIdx++;
      else if (comp == 0) {
        oHours.push(data[dataIdx]);
        dataIdx++;
      }
      else break;
    }
    result.push({
      date: new Date(curDate),
      oHours: oHours
    });
    curDate.setDate(curDate.getDate() + 1);
  }
  return result;
}

function compareDate(date1, date2) {
  var diff = date1.getFullYear() - date2.getFullYear();
  if (diff != 0) return diff;
  diff = date1.getMonth() - date2.getMonth();
  if (diff != 0) return diff;
  diff = date1.getDate() - date2.getDate();
  return diff;
}

function getPropperEpocheSpan(now) {
  var epocheStart = new Date(now.getFullYear(), now.getMonth(), 1 - 4);
  var epocheEnd = new Date(now.getFullYear(), now.getMonth() + 3, 1);
  console.log(epocheStart);
  console.log(epocheEnd);
  return [epocheStart, epocheEnd];
}

module.exports.getView = getView;
module.exports.getPropperEpocheSpan = getPropperEpocheSpan;