var mysql = require('mysql');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');
var mapping = require('../mapping.json');
var util = require('util');

var connection = mysql.createConnection({
  host: 'localhost',
  user: 'root',
  password: 'bla',
  database: 'dev_regionalkauf_cms'
});

connection.connect();

module.exports.getData = function (now, cb) {
  var epocheSpan = dateView.getPropperEpochSpan(now);
//  console.log(now);
//  console.log(epocheSpan);
//  dateArray.setEpocheSpan(epocheSpan);

//  connection.query('SELECT name, elements FROM cms_zoo_item WHERE type in ("pos", "company") ORDER BY id', function (err, rows) {
  connection.query('SELECT name, type, elements FROM cms_zoo_item WHERE id in (832)', function (err, rows) {
    console.error(err);
    console.log(rows.length);
    var result = [];
    var cnt = 0;
    var iters = rows.length;
    for (var i = 0; i < rows.length; i++) {
      var obj = JSON.parse(rows[i].elements);
      var type = rows[i].type;
      var typeM = mapping[type];

      var hours = [obj[typeM['oHoursIncl']], obj[typeM['oHoursExcl']], obj[typeM['oHoursMaybe']]];
      //console.log(util.inspect(hours, {depth: null}));
      var plz = obj[typeM['C_ZIP']][0]['value'];
      (function () {
        var name = rows[i].name;
        var idx = i;
        dateArray(epocheSpan).getData(hours, plz, function (err, dataObj) {
          console.log(dataObj);
          if (err) {
            console.log(name, err);
          }
          if (dataObj && (dataObj.intervals.length > 0 || dataObj.maybeIntervals.length > 0)) {
            cnt++;
            var view = dateView.getView(dataObj, now);
            var asString = dateView.asString(dataObj, now);
            asString = asString.asString.join(", ");
//            result.push('<div class="name">' + name + "</div> " + asString + view);
            result[idx] = ('<div class="name">' + name + "</div> " + asString + view);
          }
          if (--iters == 0) {
            console.log("Count: %d", cnt);
            result = result.filter(function (elem) {
              return !!elem;
            });
            cb(result.join('<br>'));
          }
        });
      })();
    }
  });
};



