//gibt zu betrachtenden Zeitraum an.
var _epochStart = new Date(2014, 5, 24, 0);
var _epochEnd = new Date(_epochStart.getTime() + 30 * 24 * 3600 * 1000);

function _cyclicInterval(from, until, interval, epochStart, epochEnd) {
  if(from >= until) throw new Error("startDate cant be greater than endDate");
  var resultArray = [];
  for(var offset = 0; until.getTime() + offset < epochEnd.getTime(); offset += interval) {
    resultArray.push([new Date(from.getTime() + offset), new Date(until.getTime() + offset)]);
  }
  return resultArray;
}

/**
 *
 * @param day weekday 0=sunday
 * @param timeFrom
 * @param timeFrom.h
 * @param timeFrom.m
 * @param timeUntil
 * @param timeUntil.h
 * @param timeUntil.m
 * @param epochStart
 * @param epochEnd
 */
function standard(day, timeFrom, timeUntil, epochStart, epochEnd) {
  var dayDiff = day - epochStart.getDay();
  if(dayDiff < 0)
    dayDiff += 7;

  var startDate = new Date(epochStart.getFullYear(), epochStart.getMonth(),
      epochStart.getDate() + dayDiff, timeFrom.h, timeFrom.m);
  var endDate = new Date(epochStart.getFullYear(), epochStart.getMonth(),
      epochStart.getDate() + dayDiff, timeUntil.h, timeUntil.m);
  return _cyclicInterval(startDate, endDate, 7 * 24 * 3600000, epochStart, epochEnd);
}
/**
 *
 * @param dayFrom
 * @param dayTill
 * @param timeFrom
 * @param timeFrom.h
 * @param timeFrom.m
 * @param timeUntil
 * @param timeUntil.h
 * @param timeUntil.m
 * @param epochStart {Date}
 * @param epochEnd {Date}
 * @returns {Array}
 */
function standardFromTillDay(dayFrom, dayTill, timeFrom, timeUntil, epochStart, epochEnd) {
  var result = [];
  for(var i = dayFrom; i <= dayTill; i++) {
    result = result.concat(standard(i, timeFrom, timeUntil, epochStart, epochEnd))
  }
  result = sortDateIntervals(result);
  return result;
}

function cyclic(dayFrom, dayTill, noInMonth, timeFrom, timeUntil, epochStart, epochEnd) {

}

function _getDateOccurenceInMonth(day, startDate, noInMonth) {
  startDate = new Date(startDate);
  var dayDiff = day - startDate.getDay() + 7;
  startDate.setDate(startDate.getDate() + dayDiff);

  var currentNoInMonth = Math.floor(startDate.getDate() / 7) + 1;
  while(currentNoInMonth != noInMonth) {
    startDate = new Date(startDate.getTime() + 7 * 24 * 3600000);
    currentNoInMonth = Math.floor(startDate.getDate() / 7) + 1;
  }
  return startDate;
}


function orOperator(intervals) {
  var result = [];
  for(var i = 0; i < intervals.length; i++) {
    result = result.concat(intervals[i]);
  }
  sortDateIntervals(result);
  return result;
}

function sortDateIntervals(intervals) {
  intervals.sort(function(a, b) {
    return a[0] - b[0];
  });
  return intervals;
}

function removeOverlaps(interval) {
  var i = 0;
  while(i < interval.length - 1) {
    var endFirst = interval[i][1];
    var startSecond = interval[i + 1][0];
    var endSecond = interval[i + 1][1];
    if(endFirst > startSecond) {
      interval.splice(i + 1, 1);
      interval[i][1] = endSecond;
    }
    else i++;
  }
  return interval;
}

function andOperator(interval1, interval2) {
  var result = [];

  var i = 0;
  var j = 0;
  while(i < interval1.length && j < interval2.length) {
    var start1 = interval1[i][0];
    var end1 = interval1[i][1];
    var start2 = interval2[j][0];
    var end2 = interval2[j][1];

    //no overlap
    if(end2 <= start1)
      j++;
    else if(end1 <= start2)
      i++;

    //overlap
    else {
      var newStart;
      var newEnd;
      if(end2 <= end1) {
        j++;
        newEnd = end2;
      }
      else {
        i++;
        newEnd = end1;
      }
      newStart = new Date(Math.max(start1, start2));
      result.push([newStart, newEnd]);
    }
  }
  return result;
}

function invert(interval, epochStart, epochEnd) {
  var result = [];
  var start = epochStart;
  for(var i = 0; i < interval.length; i++) {
    var end = interval[i][0];
    if(start < end)
      result.push([start, end]);
    start = interval[i][1];
  }
  if(start < epochEnd)
    result.push([start, epochEnd]);
  return result;
}

function andNotOperator(interval1, interval2) {
  var epochStart = new Date(Math.min(interval1[0][0], interval2[0][0]));
  var epochEnd = new Date(Math.min(interval1[interval1.length - 1][1], interval2[interval2.length - 1][1]));

  interval2 = invert(interval2, epochStart, epochEnd);
  return andOperator(interval1, interval2);
}

//test
//var a = _cyclicInterval(new Date(2014, 5, 23, 9), new Date(2014, 5, 23, 14), 7 * 24 * 3600 * 1000);
//var b = _cyclicInterval(new Date(2014, 5, 23, 10), new Date(2014, 5, 23, 18), 7 * 24 * 3600 * 1000);
//var c = [[new Date(2014, 5, 23, 13), new Date(2014, 6, 6, 10)]];
//var x = andNotOperator(a, b);
//var y = andNotOperator(a, c);
//console.log(y);

//var workday = standardFromTillDay(1, 5, {h: 9, m: 0}, {h: 11, m: 45}, _epochStart, _epochEnd);
//console.log(workday);

var x = _getDateOccurenceInMonth(1, new Date(), 5);
console.log(x);