var express = require('express');
var router = express.Router();
var db = require('../dataBaseQuery');

router.get('/', function(req, res) {
  var time0 = process.hrtime();
  var dateString = req.query.date;
  var now;
  if(dateString && dateString.length == 8) {
    var year = parseInt(dateString.slice(0,4));
    var month = parseInt(dateString.slice(4,6));
    var date = parseInt(dateString.slice(6,8));
    now = new Date(year, month - 1, date);
  }
  else {
    now = new Date();
  }

  db.getData(now, function(result) {
    res.render('index', { body: result });
    var time1 = process.hrtime(time0);
    console.log('Time: ' + (time1[0] + time1[1]/1e9));
  });


});

module.exports = router;
