var expect = require("chai").expect;
var fs = require('fs');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');

describe("dateView" ,function() {
  describe("calculateOpeningHours", function() {
    it("should equal", function(done) {
      var data = require('./testData/testHof.json');
      var now = new Date(2014, 4, 1);
      var epocheSpan = dateView.getPropperEpochSpan(now);

      dateArray(epocheSpan).getData(data, 93047, function(err, oHours) {
        var view = dateView.getView(oHours, now);
        console.log(view);
        var viewRef = fs.readFileSync(__dirname + '/testData/testHofView.html', {
          encoding: "utf8"
        });
        expect(view).to.equal(viewRef);
        done();
      });
    })
  })
});