var holidayMapping = require('./holidayMapping.json');
var easterSunday = require('./easterSunday');
var restRequest = require('./blndRelRequest');
var SimplQueue = require('./simplQueue');

var easterSundays = {};
var fixedHolidays = {
  101: "0101",
  106: "0601",
  501: "0105",
  808: "0808",
  815: "1508",
  103: "0310",
  131: "3110",
  111: "1101",
  121: "2412",
  122: "2512",
  123: "2612"
};

var variableOffsets = {
  301: -2,
  302: 0,
  303: 1,
  502: 39,
  601: 49,
  602: 50
};

var inverseHdMap = (function () {
  var regionH = holidayMapping["region"];
  var hMap = {};
  for (var rKey in regionH) {
    var rH = regionH[rKey];
    for (var cKey in rH) {
      var hArray = rH[cKey];
      for (var i = 0; i < hArray.length; i++) {
        var hd = hArray[i];
        if (!hMap[hd])
          hMap[hd] = [];
        hMap[hd].push({
          region: rKey,
          category: cKey
        });
      }
    }
  }
  return hMap;
}());

function Holidays(year) {

  function getEasterSunday() {
    if (!easterSundays[year])
      easterSundays[year] = easterSunday.getEasterSunday(year);
    return easterSundays[year];
  }

  function getFixedHolidays(fixedHolidays, object) {
    var result = object || {};
    for (var key in fixedHolidays) {
      var dateString = fixedHolidays[key];
      var date = parseInt(dateString.slice(0, 2));
      var month = parseInt(dateString.slice(2, 4));
      result[key] = new Date(year, month - 1, date);
    }
    return result;
  }

  function getVariableHolidaysMap(offsets, object) {
    var result = object || {};
    var easterDate = getEasterSunday();
    for (var key in offsets) {
      var offset = offsets[key];
      result[key] = new Date(year, easterDate.getMonth(), easterDate.getDate() + offset);
    }
    return result;
  }

  var holidays = getFixedHolidays(fixedHolidays);
  holidays = getVariableHolidaysMap(variableOffsets, holidays);


  function getIsAugsburg(plz) {
    return !!(86150 <= plz && plz <= 86199);
  }


  function isInEpochSpan(date, epochSpan) {
    var dateTime = date.getTime();
    return epochSpan[0].getTime() <= dateTime && dateTime <= epochSpan[1].getTime()
  }

  function getRelevantHolidayKeys(epochSpan) {
    return Object.keys(holidays).filter(function (key) {
      return isInEpochSpan(holidays[key], epochSpan);
    });
  }

  function getHolidayKeys(plz, epochSpan, cb) {
    var initKeys = getRelevantHolidayKeys(epochSpan);
    if (plz == 0) {
      return cb(null, initKeys);
    }
    var specialKeys = holidayMapping["specificHolidays"].filter(function(key) {
      return initKeys.indexOf(key) >= 0;
    });

    if (specialKeys.length == 0) {
      return cb(null, initKeys);
    }
    restRequest.getBundesland(plz, function (err, blnd) {
      if (err) return cb(err);
      var keys = holidayMapping["sureHolidays"].filter(function(key) {
        return initKeys.indexOf(key) >= 0;
      });
      var regionMap = holidayMapping["region"][blnd];
      var regHD = regionMap['default'];
      for (var i = 0; i < regHD.length; i++) {
        var key = regHD[i];
        if (initKeys.indexOf(key) >= 0) {
          keys.push(key);
        }
      }
      if(blnd != "BY") {
        cb(null, keys);
      }
      else {
        if(regionMap["augsburg"] && getIsAugsburg(plz)) {
          var augsHDs = regionMap["augsburg"];
          for (var i = 0; i < augsHDs.length; i++) {
            var key = augsHDs[i];
            if(initKeys.indexOf(key) >= 0)
              keys.push(key);
          }
        }
        if(regionMap["kath"] && regionMap["kath"].length > 0) {
          restRequest.getKatholisch(plz, function(err, kath) {
            if(err) return cb(err);
            if(kath) {
              var kathHDs = regionMap["kath"];
              for (var i = 0; i < kathHDs.length; i++) {
                var key = kathHDs[i];
                if(initKeys.indexOf(key) >= 0)
                  keys.push(key);
              }
            }
            cb(null, keys);
          })
        }
        else {
          cb(null, keys);
        }
      }
    });
  }

  this.getAllHolidays = function (plz, epochSpan, cb) {
    getHolidayKeys(plz, epochSpan, function (err, keys) {
      if (err)
        return cb(err);
      var result = [];
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var elem = holidays[key];
        if (elem)
          result.push(elem);
      }
      cb(err, result);
    });
  };

  this.getHoliday = function (id) {
    if(id == 0) {
      var ret = [];
      for(var key in holidays)
        ret.push(holidays[key]);
      return ret;
    }
    if (id in holidays)
      return [holidays[id]];
    console.error("invalid holiday id " + id);
    return null;
  };
}

module.exports = Holidays;

var hds = new Holidays(2014);
