var dateArray = require('./lib/dateArray');
var dateView = require('./lib/dateView');

function getOHIndex(incl, excl, date, plz, cb) {
  date = new Date(date.getFullYear(), date.getMonth(), date.getDate());
  var epochSpan = [new Date(date.getFullYear(), date.getMonth(), date.getDate() - 7),
    new Date(date.getFullYear(), date.getMonth(), date.getDate() + 2)];
  dateArray(epochSpan).getData([incl, excl], plz, function(err, result) {
    if(err) return cb(err);
    var fResult = result.filter(function(elem) {
      return elem[0].getTime() >= date.getTime();
    });

    cb(null, fResult);
  })
}

module.exports.getOHIndex = getOHIndex;
module.exports.dataArray = dateArray;
module.exports.dateView = dateView;
