var holidayMapping = require('./holidayMapping.json');
var easterSunday =require('./easterSunday');

var fixedHolidays = {
  101: "0101",
  106: "0601",
  501: "0105",
  808: "0808",
  815: "1508",
  103: "0310",
  131: "3110",
  111: "1101",
  121: "2412",
  122: "2512",
  123: "2612"
};

var variableOffsets = {
  301: -2,
  302: 0,
  303: 1,
  502: 39,
  601: 49,
  602: 50
};

function Holidays(year) {

  var easterSundays = {
  };

  function getEasterSunday() {
    if(!easterSundays[year])
      easterSundays[year] = easterSunday.getEasterSunday(year);
    console.log(easterSundays);
    return easterSundays[year];
  }

  function getFixedHolidays(fixedHolidays, object) {
    var result = object || {};
    for (var key in fixedHolidays) {
      var dateString = fixedHolidays[key];
      var date = parseInt(dateString.slice(0, 2));
      var month = parseInt(dateString.slice(2, 4));
      result[key] = new Date(year, month - 1, date);
    }
    return result;
  }

  function getVariableHolidaysMap(offsets, object) {
    var result = object || {};
    var easterDate = getEasterSunday();
    for (var key in offsets) {
      var offset = offsets[key];
      result[key] = new Date(year, easterDate.getMonth(), easterDate.getDate() + offset);
    }
    return result;
  }

  var holidays = getFixedHolidays(fixedHolidays);
  holidays = getVariableHolidaysMap(variableOffsets, holidays);

  this.getHolidayIDs = function (region, kath) {
    if (region === 'BY') {

    }
  };

  this.getAllHolidays = function (region, kath) {
    var result = [];
    for (var key in holidays) {
      result.push(holidays[key]);
    }
    return result;
  };

  this.getHoliday = function (id) {
    if (id in holidays)
      return [holidays[id]];
    console.error("invalid holiday id " + id);
    return null;
  };
}

module.exports = Holidays;