var mysql = require('mysql');

var config = require('../config.json');
var blndMapping = {
  "Baden-Württemberg": "BW",
  "Niedersachsen": "NI",
  "Bayern": "BY",
  "Nordrhein-Westfalen": "NW",
  "Berlin": "BE",
  "Rheinland-Pfalz": "RP",
  "Brandenburg": "BB",
  "Saarland": "SL",
  "Bremen": "HB",
  "Sachsen": "SN",
  "Hamburg": "HH",
  "Sachsen-Anhalt": "ST",
  "Hessen": "HE",
  "Schleswig-Holstein": "SH",
  "Mecklenburg-Vorpommern": "MV",
  "Thüringen": "TH"
};
var connection = mysql.createConnection(config["mysqlConfig"]);

module.exports.getBundesland = function(plz, cb) {
  connection.query("SELECT bundesland FROM postleitzahlen WHERE plz = '" + plz + "'", function (err, result) {
    if (err) return cb(err);

    var blnd;
    try {
      blnd = result[0]['bundesland'];
      blnd = blndMapping[blnd];
    }
    catch(err) {
      return cb(err);
    }

    if (blnd === undefined)
      return cb(new Error("no bundesland found for plz " + plz));
    cb(null, blnd);
  });
};

module.exports.getKatholisch = function(plz, cb) {
  connection.query("SELECT feiertag FROM relHoliday WHERE plz = '" + plz + "'", function (err, result) {
    if (err) return cb(err);
    var feiertag;
    try {
      feiertag = result[0]["feiertag"];
    }
    catch (error) {
      return cb(err);
    }
    if (feiertag === undefined)
      return cb(new Error("no entry found in religion table for plz " + plz));
    cb(null, !!feiertag);
  });
};

/*getBundesland(4600, function (err, result) {
 console.log(err);
 console.log(result);
 });*/
/*getKatholisch(93047, function (err, result) {
 console.log(err);
 console.log(result);
 });*/
