function Holidays(year) {
/*  var mapping = {
    0: "Alle",
    101: "Neujahrstag",
    106: "Hl. drei Koenige",
    301: "Karfreitag",
    302: "Ostersonntag",
    303: "Ostermontag",
    501: "Tag der Arbeit",
    502: "Himmelfahrt",
    601: "Pfingstsonntag",
    602: "Pfingstmontag",
    808: "Augsburger Friedensfest",
    815: "Mariae Himmelfahrt",
    103: "Tag der Deutschen Einheit",
    131: "Reformationstag",
    111: "Allerheiligen",
    121: "Heilig Abend",
    122: "Erster Weihnachtstag",
    123: "Zweiter Weihnachtstag"};*/

  var fixedHolidays = {
    101: "0101",
    106: "0601",
    501: "0105",
    808: "0808",
    815: "1508",
    103: "0310",
    131: "3110",
    111: "1101",
    121: "2412",
    122: "2512",
    123: "2612"
  };

  var variableOffsets = {
    301: -2,
    302: 0,
    303: 1,
    502: 39,
    601: 49,
    602: 50
  };

  function getEasterSunday() {
    return new Date(2014, 3, 5);
  }

  function getFixedHolidays(fixedHolidays, object) {
    var result = object || {};
    for(var key in fixedHolidays) {
      var dateString = fixedHolidays[key];
      var date = parseInt(dateString.slice(0,2));
      var month = parseInt(dateString.slice(2,4));
      console.log(date, month);
      result[key] = new Date(year, month - 1, date);
      console.log(result[key]);
    }
    return result;
  }

  function getVariableHolidaysMap(offsets, object) {
    var result = object || {};
    var easterDate = getEasterSunday();
    for(var key in offsets) {
      var offset = offsets[key];
      result[key] = new Date(year, easterDate.getMonth(), easterDate.getDate() + offset);
    }
    return result;
  }

  console.log(getFixedHolidays(fixedHolidays));
  console.log(getVariableHolidaysMap(variableOffsets));
}

new Holidays(2014);

module.exports = Holidays;