var mysql = require('mysql');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');
var moment = require('moment');

var fs = require('fs');

var holidays = require('../lib/holidays');
holidays.setTestHandler();

var connection = mysql.createConnection({
  host: 'localhost',
  user: 'root',
  password: 'bla',
  database: 'regiostart'
});

connection.connect();

var dateSpan = [new Date(2014, 0, 0), new Date(2016, 0, 0)];
console.log(dateSpan);
dateArray = dateArray(dateSpan);

var extractionDate = moment().format('YYYYMMDD');

connection.query('SELECT id, name, elements FROM cms_zoo_item WHERE id  in (2650, 2422)', function (err, rows) {
  for (var i = 0; i < rows.length; i++) {
    var id = rows[i].id;
    var json = JSON.parse(rows[i].elements);
    dateArray.getData(json, 93161, function (err, result) {
      if (err) return console.error(err);
      fs.writeFileSync('../testData/input/' + extractionDate + '_' + id + '.json', JSON.stringify(json));
      fs.writeFileSync('../testData/validation/' + extractionDate + '_' + id + '.json', JSON.stringify(result));
    });
  }
});

connection.end();