var assert = require('assert');
var dateArray = require('../lib/dateArray');
var fs = require('fs');
var path = require('path');
var async = require('async');

var holidays = require('../lib/holidays');
holidays.setTestHandler();

var dateSpan = [new Date(2014, 0, 0), new Date(2016, 0, 0)];
dateArray = dateArray(dateSpan);

describe("dateArray", function () {
  describe("calculateOpeningHours", function () {
    it("should equal Testdata", function (done) {
      console.log(process.cwd());
      var inpPath = './testData/input/';
      var inpFiles = fs.readdirSync(inpPath);
      var valPath = 'testData/validation/';
      var files = inpFiles.map(function (file) {
        return {
          source: JSON.parse(fs.readFileSync(path.join(inpPath, file))),
          validation: JSON.parse(fs.readFileSync(path.join(valPath, file)).toString())
        }
      });
      async.each(files, function (file, cb) {
        dateArray.getData(file.source, 93161, function (err, result) {
          if (err) return cb(err);

          assert.deepEqual(JSON.stringify(result.intervals), JSON.stringify(file.validation.intervals));
          cb();
        })
      }, function (err) {
        done(err);
      });
    })
  })
});