function SimplQueue(finisher) {
  this._finisher = finisher;
  this._queue = [];
  this._started = false;
}
SimplQueue.prototype.push = function (cb) {
  this._queue.push(cb);
  if (this._finisher && !this._started) {
    this._started = true;
    var next = this._queue.shift();
    next(this._handler.bind(this));
  }
};

SimplQueue.prototype.start = function () {
  if (this._started) return;
  this._started = true;
  var next = this._queue.shift();
  if (next)
    next(this._handler.bind(this));
  else this._finisher();
};

SimplQueue.prototype._handler = function (err) {
  if (err) return this._finisher(err);
  var next = this._queue.shift();
  if (next) {
    next(this._handler.bind(this));
  }
  else this._finisher(null);
};

module.exports = SimplQueue;

function doStuff() {
  var queue = new SimplQueue(function (err) {
    console.log(err);
    console.log("finished");
  });
  for (var i = 0; i < 100; i++) {
    queue.push(function (cb) {
      setTimeout(function () {
        if(Math.random() > 0.9)
          return cb(new Error("muh"));
        console.log(+new Date());
        cb(null);
      }, 50)
    })
  }
}

doStuff();