"use strict";
var Promise = require('bluebird');
var dateArray = require('./lib/dateArray');
var dateView = require('./lib/dateView');
var splitMidnight = require('./lib/timeUtils').splitMidnight;

function mapEvents(intervals) {
  if (intervals) {
    // var splitIntervals = splitMidnight(intervals);
    var splitIntervals = intervals;
    return splitIntervals.map(function(evt) {
      return {
        startDate: evt[0],
        endDate: evt[1]
      }
    })
  }
}

function transform(x) {
  var res = [];
  for (var i = 0; i < x.length; i++) {
    res.push({
      from: x[i][0],
      to: x[i][1]
    })
  }
  return res;
}

// intervals for elasticsearch index (to allow opening hours filters)
function getOHIndex(info, today, cb) {
  today = new Date(today.getFullYear(), today.getMonth(), today.getDate());

  var epochSpan = [new Date(today.getFullYear(), today.getMonth(), today.getDate() - 7),
    new Date(today.getFullYear(), today.getMonth() + 5, today.getDate())];
  dateArray(epochSpan).getData(info, function (err, result) {
    if (err) return cb(err);
    var resultSure = result.intervals;
    var resultMaybe = result.maybeIntervals;

    var fResult = {
      sure: transform(resultSure),
      maybe: transform(resultMaybe)
    };

    if (result.customIntervals && result.customIntervals.emergency) {
      fResult.emergency = transform(result.customIntervals.emergency);
    }

    cb(null, fResult);
  })
}

function mapCustomIntervals(customIvals) {
  var res = {};
  if (customIvals) {
    for (let key in customIvals) {
      res[key] = mapEvents(customIvals[key]);
    }
  }
  return res;
}

// for detail view, events* contain intervals {from, to}
function getFull(info, now, cb) {
  var epocheSpan = dateView.getPropperEpochSpan(now);
  dateArray(epocheSpan).getData(info, function (err, dataObj) {
    if (err) return cb(err);
    var short = dateView.asString(dataObj, now);
    var res = {
      //threeMonth: dateView.threeMonth(dataObj, now),
      isOpen: short.isOpen,
      text: short.text,
      status: short.status,
      // weekView: dateView.weekViewData(dataObj, now),
      events: mapEvents(dataObj.intervals),
      eventsMaybe: mapEvents(dataObj.maybeIntervals),
      customEvents: mapCustomIntervals(dataObj.customIntervals)
    };

    cb(null, res);
  })
}

// for list view
function getShort(info, now, cb) {
  var epocheSpan = dateView.getPropperEpochSpan(now);
  dateArray(epocheSpan).getData(info, function (err, dataObj) {
    if (err) return cb(err);
    var obj = dateView.asString(dataObj, now);
    cb(null, obj);
  })
}


// info is {state: "Bayern", zip: 1234, religiousHoliday: true, data: {include, exclude, maybe}}

module.exports = {
  getOHIndex: Promise.promisify(getOHIndex),
  getFull: Promise.promisify(getFull),
  getShort: Promise.promisify(getShort)
};

