var assert = require('assert');
var dateArray = require('../lib/dateArray');
var fs = require('fs');
var path = require('path');
var async = require('async');
var tmUtils = require('../lib/timeUtils');
var dateView = require('../lib/dateView');
var renderView = require('../lib/renderView');


var holidays = require('../lib/holidays');
holidays.setTestHandler();

var dateSpan = [new Date(2014, 0, 0), new Date(2015, 0, 0)];
var now = new Date(2014, 7, 10);

dateArray = dateArray(dateSpan);

Date.prototype.toISOString = Date.prototype.toLocaleString;

describe("calculateOpeningHours", function () {

  var inpPath = './testData/input/';
  var outputPath = './testData/output/';
  var inpFiles = fs.readdirSync(inpPath);
  var valPath = 'testData/validation/';
  var files = inpFiles.map(function (file) {
    try {
      var validationHtml = fs.readFileSync(path.join(valPath, file.replace('.json', '.html'))).toString();
    }
    catch (err) {
      if (!(err.errno === 34)) {
        throw  err;
      }
    }
    return {
      file: file,
      outputPath: path.join(outputPath, file),
      source: JSON.parse(fs.readFileSync(path.join(inpPath, file))),
      validation: JSON.parse(fs.readFileSync(path.join(valPath, file)).toString()),
      validationHtml: validationHtml
    }
  });

  files.forEach(function (file) {
    dateArray.getData(file.source, 93161, function (err, result) {
      it('intervals should equal ' + file.file, function (done) {
        if (err) {
          console.log(err);
          result = {error: err.toString()};
          assert.deepEqual(JSON.stringify(result), JSON.stringify(file.validation));
        }
        else {
          fs.writeFileSync(file.outputPath, JSON.stringify(result));
          assert.deepEqual(JSON.stringify(result.intervals), JSON.stringify(file.validation.intervals));
          assert.deepEqual(JSON.stringify(result.maybeIntervals), JSON.stringify(file.validation.maybeIntervals));
          assert.deepEqual(JSON.stringify(result.holidays), JSON.stringify(file.validation.holidays));
        }
        done();
      });

      if(!err) {
        it('views should equal ' + file.file, function (done) {
          var renderedView = renderView.render(dateView.getView(result, now));
          fs.writeFileSync(file.outputPath.replace('.json', '.html'), renderedView);
          assert.deepEqual(renderedView, file.validationHtml);
          done();
        });
      }
    })
  });
});


function merge(a, b) {
  if (a.length === 0)
    return b;
  if (b.length === 0)
    return a;

  var c = [];
  var l1 = a.length;
  var l2 = b.length;
  var l = l1 + l2;
  var i = 0;
  var j = 0;
  for (var cnt = 0; cnt < l; cnt++) {
    if (i < l1 && (j >= l2 || a[i][0] - b[j][0] < 0)) {
      c.push(a[i++]);
    }
    else {
      c.push(b[j++]);
    }
  }
  return c;
}

