module.exports = function(config) {
  var _config = require('./config.json');
  if(config) _config["mysqlConfig"] = config;

  var dateArray = require('./lib/dateArray');
  var dateView = require('./lib/dateView');

  function getOHIndex(incl, excl, date, plz, cb) {
    date = new Date(date.getFullYear(), date.getMonth(), date.getDate());
    var epochSpan = [new Date(date.getFullYear(), date.getMonth(), date.getDate() - 7),
      new Date(date.getFullYear(), date.getMonth(), date.getDate() + 2)];
    dateArray(epochSpan).getData([incl, excl], plz, function(err, result) {
      if(err) return cb(err);
      result = result.intervals;
      var fResult = result.filter(function(elem) {
        return elem[0].getTime() >= date.getTime();
      });

      cb(null, fResult);
    })
  }

  return {
    getOHIndex: getOHIndex,
    dateArray: dateArray,
    dateView: dateView
  }
};
