var tmUtils = require('./timeUtils');
var now = new Date();

var includeString = "810a6deb-46f2-4fa8-b779-bb5c2a6b5577";
var excludeString = "bb74c170-b06f-4d2b-ab88-2f6bf9ce8068";

var _epochStart = new Date();
_epochStart.setDate(_epochStart.getDate() - 14);
var _epochEnd = new Date(_epochStart.getTime() + 31 * 24 * 3600000);
var epocheSpan = [_epochStart, _epochEnd];


function calculateOpeningHours(json) {
  var jsonIncl = json[includeString];
  var jsonExcl = json[excludeString];

  var resultIncl = getIntervals(jsonIncl);
  var resultExcl = getIntervals(jsonExcl);

  var result = tmUtils.andNotOperator(resultIncl, resultExcl);
  console.log(result);


}

function getHolidays(data) {


}
function getIntervals(json) {
  var result = [];
  var holidays = [];
  for(var key in json) {
    var x = getOpeningHours(json[key]);
    if(x)
      result.push(x);
    else {
      x = getHolidays(json[key])
      if(x)
        holidays.push(x);
    }
  }
  return tmUtils.orOperator(result);
}


function getDaySpan(dayoption) {
  if(dayoption < 7) return [dayoption, dayoption];
  switch(dayoption) {
    case 7:
      return [0, 0];
    case 8:
      return [0, 7];
    case 9:
      return [1, 5];
    case 10:
      return [1, 6];
    default:
      throw "Invalid day option";
  }
}

function parseTime(time) {
  var split = time.split(":");
  return {
    h: parseInt(split[0]) || 0,
    m: parseInt(split[1]) || 0
  }
}

function parseDate(date, addOneDay) {
  if(date.length == 0)
    return null;

  var year = now.getFullYear();
  var split = date.split(".");
  var month = parseInt(split[1]) - 1;
  var day = parseInt(split[0]) + addOneDay ? 1 : 0;
  return new Date(year, month, day);
}


function getOpeningHours(data) {
  var option = data["option"]["0"];

  var dayoption = parseInt(data["dayoption"]["0"]);
  var daySpan = getDaySpan(dayoption);
  var startDate = parseDate(data["opening_day_from"]) || _epochStart;
  var endDate = parseDate(data["opening_day_to"], true) || _epochEnd;
  var dateSpan = [startDate, endDate];

  var timeSpan = [parseTime(data["opening_from"]), parseTime(data["opening_to"])];
  var result = {type: 0};
  switch(option) {
    case "default":
      return tmUtils.standardFromTillDay(daySpan, timeSpan, epocheSpan, 7);
    case "season":
      return tmUtils.standardFromTillDay(daySpan, timeSpan, dateSpan, 7);
    case "repeatable":
      var repeatOption = parseInt(data["repeatoption"]["0"]);
      var noInMonth;
      if(repeatOption <= 4) noInMonth = repeatOption;
      else if(repeatOption == 30) noInMonth = -1;

      if(noInMonth)
        return tmUtils.cyclicFromTillDay(daySpan, noInMonth, timeSpan, dateSpan, epocheSpan);

      switch(repeatOption) {
        case 14:
        case 21:
        case 28:
          return tmUtils.standardFromTillDay(daySpan, timeSpan, dateSpan, repeatOption);
        default:
          console.error("invalid repeatoption");
      }

  }

}

calculateOpeningHours(require('./testData/testHof.json'));