function SimplQueue(finisher) {
  this._queue = [];
  this._started = false;
  this._boundHandler = this._handler.bind(this);
}
SimplQueue.prototype.push = function (cb) {
  this._queue.push(cb);
  if (this._finisher && !this._started) {
    this._started = true;
    var next = this._queue.shift();
    next(this._handler.bind(this));
  }
};
SimplQueue.prototype.finish = function(finisher) {
  this._finisher = finisher;
  this._start();
};

SimplQueue.prototype._start = function () {
  if (this._started) return;
  this._started = true;
  var next = this._queue.shift();
  if (next)
    next(this._boundHandler);
  else this._finisher();
};

SimplQueue.prototype._handler = function (err) {
  if (err) return this._finisher(err);
  var next = this._queue.shift();
  if (next) {
    next(this._boundHandler);
  }
  else this._finisher(null);
};

module.exports = SimplQueue;


//function doStuff() {
//  var queue = new SimplQueue();
//  var res = [];
//  for (var i = 0; i < 200; i++) {
//    queue.push(function (cb) {
//      setTimeout(function () {
//        if(Math.random() > 1)
//          return cb(new Error("muh"));
//        res.push(+new Date());
//        cb(null);
//      }, 10)
//    });
//    var time0 = process.hrtime();
//    queue.finish(function (err) {
//      if(err) return console.log(err);
//      var time = process.hrtime(time0);
//      console.log(time[0] * 1000 + time[1]*1e-6);
////      console.log(res);
//    })
//  }
//}
//
//doStuff();
