var blndMapping = {
  "Baden-Württemberg": "BW",
  "Niedersachsen": "NI",
  "Bayern": "BY",
  "Nordrhein-Westfalen": "NW",
  "Berlin": "BE",
  "Rheinland-Pfalz": "RP",
  "Brandenburg": "BB",
  "Saarland": "SL",
  "Freie Hansestadt Bremen": "HB",
  "Sachsen": "SN",
  "Freie und Hansestadt Hamburg": "HH",
  "Sachsen-Anhalt": "ST",
  "Hessen": "HE",
  "Schleswig-Holstein": "SH",
  "Mecklenburg-Vorpommern": "MV",
  "Thüringen": "TH"
};


module.exports = {
  getBundesland: function (info, cb) {
    if(!info.state) {
      console.log(info);
      return cb(new Error("no state given"));
    }

    var mappedState = blndMapping[info.state];
    if(mappedState) return cb(null, mappedState);
    else {
      if(info.state = "Tschechien") return cb(null, "BY");
      return cb(new Error("no state mapping found for " + info.state))
    }
  },
  getKatholisch: function (info, cb) {
    var isHoliday;
    if(info.religiousHoliday === undefined) isHoliday = false;
    else isHoliday = info.religiousHoliday;
    return cb(null, isHoliday);
  }
};