var holidayMapping = require('./holidayMapping.json');

var fixedHolidays = {
  101: "0101",
  106: "0601",
  501: "0105",
  808: "0808",
  815: "1508",
  103: "0310",
  131: "3110",
  111: "1101",
  121: "2412",
  122: "2512",
  123: "2612"
};

var variableOffsets = {
  301: -2,
  302: 0,
  303: 1,
  502: 39,
  601: 49,
  602: 50
};

var specificHolidays = getRegionSpecificHolidays(holidayMapping);
console.log(holidayMapping.sureHolidays.concat(holidayMapping.specificHolidays).sort());

function getRegionSpecificHolidays(holidayMapping) {
  var data = holidayMapping["region"];
  var ids = [];
  for (var key in data) {
    var obj = data[key];
    for (var i = 0; i < obj.length; i++) {
      if (ids.indexOf(obj[i]) < 0)
        ids.push(obj[i]);
    }
  }
  return ids.sort();
}

function sureHolidays() {
  var holidays = [];
  for (var key in fixedHolidays) {
    if(specificHolidays.indexOf(key) < 0)
      holidays.push(key);
  }
  for (var key in variableOffsets) {
    if(specificHolidays.indexOf(key) < 0)
      holidays.push(key);
  }
  return holidays;
}

function Holidays(year) {

  var easterSundays = {
    2014: new Date(2014, 3, 20),
    2015: new Date(2015, 3, 5),
    2016: new Date(2016, 2, 27)
  };

  function getEasterSunday() {
    return easterSundays[year];
  }

  function getFixedHolidays(fixedHolidays, object) {
    var result = object || {};
    for (var key in fixedHolidays) {
      var dateString = fixedHolidays[key];
      var date = parseInt(dateString.slice(0, 2));
      var month = parseInt(dateString.slice(2, 4));
      result[key] = new Date(year, month - 1, date);
    }
    return result;
  }

  function getVariableHolidaysMap(offsets, object) {
    var result = object || {};
    var easterDate = getEasterSunday();
    for (var key in offsets) {
      var offset = offsets[key];
      result[key] = new Date(year, easterDate.getMonth(), easterDate.getDate() + offset);
    }
    return result;
  }

  var holidays = getFixedHolidays(fixedHolidays);
  holidays = getVariableHolidaysMap(variableOffsets, holidays);

  this.getHolidayIDs = function (region, kath) {
    if (region === 'BY') {

    }
  };

  this.getAllHolidays = function (region, kath) {
    var result = [];
    for (var key in holidays) {
      result.push(holidays[key]);
    }
    return result;
  };

  this.getHoliday = function (id) {
    if (id in holidays)
      return [holidays[id]];
    console.error("invalid holiday id " + id);
    return null;
  };
}

module.exports = Holidays;