var tmUtils = require('./timeUtils');
var Holidays = require('./holidays');
var now = new Date();
var holidaysGetter = new Holidays(now.getFullYear());

var epochSpan = testEpochSpan();

function setEpocheSpan(_epocheSpan) {
  epochSpan = _epocheSpan;
}

function testEpochSpan() {
  var _epochStart = new Date();
  _epochStart = new Date(_epochStart.getFullYear(), _epochStart.getMonth(), _epochStart.getDate());
  _epochStart.setDate(_epochStart.getDate() - 30);
  var _epochEnd = new Date(_epochStart.getTime() + 130 * 24 * 3600000);
  return [_epochStart, _epochEnd];
}

function calculateOpeningHours(json) {
  var includeString = "810a6deb-46f2-4fa8-b779-bb5c2a6b5577";
  var excludeString = "bb74c170-b06f-4d2b-ab88-2f6bf9ce8068";

  var jsonIncl = json[includeString];
  var jsonExcl = json[excludeString];
  
  if (!jsonIncl) {
    throw new Error('no openinghours model found');
  }

  var resultIncl = [];
  var resultExcl = [];
  var holidayIncl = [];

  var data, option, key;
  for (key in jsonIncl) {
    data = jsonIncl[key];
    option = getOption(data);
    if (option == "holiday")
      holidayIncl = holidayIncl.concat(getHolidays(data));
//    else if (option == "vacation") {
//      resultExcl.push(getOpeningHours(data, option));
//    }
    else
      resultIncl.push(getOpeningHours(data, option));
  }

  if (jsonExcl) {
    for (key in jsonExcl) {
      data = jsonExcl[key];
      option = getOption(data);
      resultExcl.push(getOpeningHours(data, option));
    }
    resultExcl = tmUtils.orOp(resultExcl);
  }

  var allHolidays = getAllHolidays();

  allHolidays = tmUtils.andOp(allHolidays, [epochSpan]);
  holidayIncl = tmUtils.andOp(holidayIncl, [epochSpan]);

  resultIncl = tmUtils.orOp(resultIncl);
  resultIncl = tmUtils.andNotOp(resultIncl, allHolidays);
  resultIncl = tmUtils.orOp([resultIncl, holidayIncl]);

  var result = resultIncl;
  if (jsonExcl)
    result = tmUtils.andNotOp(resultIncl, resultExcl);

  return  result;
}

function getDaySpan(data) {
  var dayoption = parseInt(data["dayoption"]["0"]);
  if (dayoption < 7) return [dayoption, dayoption];
  switch (dayoption) {
    case 7:
      return [0, 0];
    case 8:
      return [0, 7];
    case 9:
      return [1, 5];
    case 10:
      return [1, 6];
    default:
      throw new Error("Invalid day option: " + dayoption);
  }
}

function parseTime(time) {
  var split = time.split(":");
  return {
    h: parseInt(split[0]) || 0,
    m: parseInt(split[1]) || 0
  }
}


//TODO now.getFullYear muss verschwinden, Jahreswechsel!!!!
function parseDate(date, addOneDay) {
  if (date.length == 0)
    return null;

  var year = now.getFullYear();
  var split = date.split(".");
  var month = parseInt(split[1]) - 1;
  var day = parseInt(split[0]) + (addOneDay ? 1 : 0);

  return new Date(year, month, day);
}

function getHolidays(data) {
  var option = data["option"]["0"];
  if (option != "holiday") {
    throw new Error('not holiday: ' + option);
  }

  var timeSpan = getTimeSpan(data);
  var holidayId = data["holidayoption"][0];
  var days = holidaysGetter.getHoliday(holidayId);

  var intervals = days.map(function (date) {
    return tmUtils.singleDay(date, timeSpan);
  });
  tmUtils.sort(intervals);
  return intervals;
}

function getAllHolidays() {
  var days = holidaysGetter.getHoliday(0);
  var intervals = days.map(function (date) {
    return tmUtils.singleDay(date);
  });
  tmUtils.sort(intervals);
  return intervals;
}

function getDateSpan(data) {
  var startDate = parseDate(data["opening_day_from"]) || epochSpan[0];
  var endDate = parseDate(data["opening_day_to"], true) || epochSpan[1];
  //TODO start und enddate vertauschen, falls enddate < startdate
  return [startDate, endDate];
}

function getTimeSpan(data) {
  return [parseTime(data["opening_from"]), parseTime(data["opening_to"])];
}

function getOption(data) {
  return data["option"][0];
}

function getOpeningHours(data, option) {
  option = option || getOption(data);

  switch (option) {
    case "default":
      return getOpeningHoursDefault(data);
    case "season":
      return getOpeningHoursSeason(data);
    case "repeatable":
      return getOpeningHoursRepeatable(data);
    case "vacation":
      return getOpeningHoursVacation(data);
    case "":
      return [];
    default:
      throw new Error("option not supported: " + option);
      return [];
  }
}

function getOpeningHoursDefault(data) {
  var daySpan = getDaySpan(data);
  var timeSpan = getTimeSpan(data);
  return tmUtils.standardFromTillDay(daySpan, timeSpan, epochSpan, epochSpan, 7);
}

function getOpeningHoursSeason(data) {
  var daySpan = getDaySpan(data);
  var timeSpan = getTimeSpan(data);
  var dateSpan = getDateSpan(data);
  return tmUtils.standardFromTillDay(daySpan, timeSpan, dateSpan, epochSpan, 7);
}

function getOpeningHoursVacation(data) {
  var dateSpan = getDateSpan(data);
  return tmUtils.dateSpan(dateSpan);
}

function getOpeningHoursRepeatable(data) {
  var daySpan = getDaySpan(data);
  var timeSpan = getTimeSpan(data);
  var dateSpan = getDateSpan(data);
  var repeatOption = parseInt(data["repeatoption"]["0"]);

  var noInMonth;
  if (repeatOption <= 4) noInMonth = repeatOption;
  else if (repeatOption == 30) noInMonth = -1;
  if (noInMonth)
    return tmUtils.cyclicFromTillDay(daySpan, noInMonth, timeSpan, dateSpan, epochSpan);
  else {
    switch (repeatOption) {
      case 14:
      case 21:
      case 28:
        return tmUtils.standardFromTillDay(daySpan, timeSpan, dateSpan, epochSpan, repeatOption);
      default:
        throw new Error("invalid repeatoption");
    }
  }
}

module.exports.getData = calculateOpeningHours;
module.exports.setEpocheSpan = setEpocheSpan;


