"use strict";

var assert = require('assert');
var moment = require('moment');

function compareTimeSpan(timeSpan) {
  var from = timeSpan[0];
  var till = timeSpan[1];
  if (from.h == till.h)
    return from.m - till.m;
  else
    return from.h - till.h
}

function transformTimeSpan(timeSpan) {
  if (compareTimeSpan(timeSpan) >= 0) {
    timeSpan[1].h += 24;
  }
  return timeSpan;
}

//function _cyclicInterval2(from, until, interval, epochStart, epochEnd) {
//  if(from.getTime() >= until.getTime()) throw new Error("startDate cant be greater than endDate");
//  var resultArray = [];
//  for(var offset = 0; until.getTime() + offset < epochEnd.getTime(); offset += interval) {
//    resultArray.push([new Date(from.getTime() + offset), new Date(until.getTime() + offset)]);
//  }
//  return resultArray;
//}

function _cyclicInterval(from, until, distanceDays, epochStart, epochEnd) {
  if (from.getTime() >= until.getTime()) throw new Error("startDate cant be greater than endDate");
  var resultArray = [];
  from = new Date(from);
  until = new Date(until);

  while (until.getTime() <= epochEnd.getTime()) {
    resultArray.push([new Date(from), new Date(until)]);
    from.setDate(from.getDate() + distanceDays);
    until.setDate(until.getDate() + distanceDays);
  }
  return resultArray;
}

function _standard(day, timeFrom, timeUntil, startDate, endDate, distanceDays) {
  var dayDiff = day - startDate.getDay();
  if(dayDiff > 0) dayDiff -= 7;

  var date0 = new Date(startDate.getFullYear(), startDate.getMonth(),
    startDate.getDate() + dayDiff, timeFrom.h, timeFrom.m);

  var date1 = new Date(startDate.getFullYear(), startDate.getMonth(),
    startDate.getDate() + dayDiff, timeUntil.h, timeUntil.m);

  return _cyclicInterval(date0, date1, distanceDays, startDate, endDate);
}

function standardFromTillDay(daySpan, timeSpan, dateSpan, epochSpan, daysDistance) {
  if(dateSpan[0] > epochSpan[1] || dateSpan[1] < epochSpan[0]) {
    return [];
  }
  timeSpan = transformTimeSpan(timeSpan);
  var dayFrom = daySpan[0];
  var dayTo = daySpan[1];
  var timeFrom = timeSpan[0];
  var timeUntil = timeSpan[1];
  var epochStart = new Date(dateSpan[0]);
  var epochEnd = dateSpan[1];
  var firstDays = _standard(dayFrom, timeFrom, timeUntil, epochStart, epochEnd, daysDistance);
  var result = firstDays.slice();

  for (var offset = 1; offset <= dayTo - dayFrom; offset++) {
    for (var i = 0; i < firstDays.length; i++) {
      var start = new Date(firstDays[i][0]);
      var end = new Date(firstDays[i][1]);
      start.setDate(start.getDate() + offset);
      end.setDate(end.getDate() + offset);
      if (end.getTime() <= epochEnd.getTime())
        result.push([start, end]);
    }
  }
  result = sort(result);
  result = andOp(result, [dateSpan]);
  result = andOp(result, [epochSpan]);
  return result;
}

function cyclicFromTillDay(daySpan, noInMonth, timeSpan, dateSpan, epochSpan) {
  if (!epochSpan)
    epochSpan = dateSpan;

  timeSpan = transformTimeSpan(timeSpan);
  var dayFrom = daySpan[0];
  var dayTo = daySpan[1];
  var timeFrom = timeSpan[0];
  var timeUntil = timeSpan[1];
  var startDate = dateSpan[0];
  var endDate = dateSpan[1];

  //limit dateSpan to epochSpan, to reduce costs
  if (endDate.getTime() > epochSpan[1].getTime()) endDate = epochSpan[1];
  if (startDate.getTime() < epochSpan[0].getTime()) {
    var t = epochSpan[0];
    //substract 1 month to cover special cases
    startDate = new Date(t.getFullYear(), t.getMonth() - 1, t.getDate())
  }

  var result = [];
  startDate = new Date(startDate);

  while (true) {
    var date0 = _getNextNoInMonthOccurence(dayFrom, startDate, noInMonth);
    date0.setHours(timeFrom.h);
    date0.setMinutes(timeFrom.m);
    var date1 = new Date(date0);
    date1.setHours(timeUntil.h);
    date1.setMinutes(timeUntil.m);
    if (date1.getTime() > endDate.getTime())
      break;
    else {
      result.push([date0, date1]);
      startDate = new Date(date1);
      startDate.setDate(startDate.getDate() + 1);
      for (var offset = 1; offset <= dayTo - dayFrom; offset++) {
        date0 = new Date(date0);
        date1 = new Date(date1);
        date0.setDate(date0.getDate() + 1);
        date1.setDate(date1.getDate() + 1);
        if (date1.getTime() <= endDate.getTime())
          result.push([date0, date1]);
        else break;
      }
    }
  }

  result = andOp(result, [epochSpan]);
  return result;
}

function _getNextNoInMonthOccurence(day, startDate, noInMonth) {
  startDate = new Date(startDate);
  console.log('-----');
  console.log(startDate);
  var _noInMonth;
  if (noInMonth == -1) {
    _noInMonth = 1;
    startDate.setDate(startDate.getDate() + 7);
  }
  else {
    _noInMonth = noInMonth;
  }

  var dayDiff = day - startDate.getDay();
  if (dayDiff < 0) dayDiff += 7;
  startDate.setDate(startDate.getDate() + dayDiff);
  console.log(startDate);

  var currentNoInMonth = Math.ceil(startDate.getDate() / 7);
  while (currentNoInMonth != _noInMonth) {
    startDate.setDate(startDate.getDate() + 7);
    //startDate = new Date(startDate.getTime() + 7 * 24 * 3600000);
    currentNoInMonth = Math.ceil(startDate.getDate() / 7);
  }

  if (noInMonth == -1) {
    startDate.setDate(startDate.getDate() - 7);
  }
  console.log(startDate);
  return startDate;
}

/**
 * return a timespan on one day, if no timespan is given,
 * the whole day is returned
 *
 * @param date
 * @param [timeSpan]
 * @returns {*[]}
 */
function singleDay(date, timeSpan) {
  var startDate, endDate;
  if (timeSpan) {
    timeSpan = transformTimeSpan(timeSpan);
    startDate = new Date(date.getFullYear(), date.getMonth(), date.getDate(), timeSpan[0].h, timeSpan[0].m);
    endDate = new Date(date.getFullYear(), date.getMonth(), date.getDate(), timeSpan[1].h, timeSpan[1].m);
  }
  else {
    startDate = new Date(date.getFullYear(), date.getMonth(), date.getDate());
    endDate = new Date(date.getFullYear(), date.getMonth(), date.getDate() + 1);
  }

  return [startDate, endDate];
}

function dateSpan(dateSpan) {
  var d0 = dateSpan[0];
  var d1 = dateSpan[1];
  var startDate = new Date(d0.getFullYear(), d0.getMonth(), d0.getDate());
  var endDate = new Date(d1.getFullYear(), d1.getMonth(), d1.getDate());
  return [
    [startDate, endDate]
  ];
}

function orOp(intervals) {
  var result = [];
  for (var i = 0; i < intervals.length; i++) {
    result = result.concat(intervals[i]);
  }
  sort(result);
  mergeOverlaps(result);
  return result;
}

function sort(intervals) {
  intervals.sort(function (a, b) {
    return a[0].getTime() - b[0].getTime();
  });
  return intervals;
}

function mergeOverlaps(interval) {
  var i = 0;
  while (i < interval.length - 1) {
    var endFirst = interval[i][1];
    var startSecond = interval[i + 1][0];
    var endSecond = interval[i + 1][1];
    if (endFirst.getTime() > startSecond.getTime()) {
      interval.splice(i + 1, 1);
      interval[i][1] = new Date(Math.max(endFirst, endSecond));
    }
    else i++;
  }
  return interval;
}

function andOp(interval1, interval2) {
  var result = [];

  var i = 0;
  var j = 0;
  while (i < interval1.length && j < interval2.length) {
    var start1 = interval1[i][0];
    var end1 = interval1[i][1];
    var start2 = interval2[j][0];
    var end2 = interval2[j][1];

    //no overlap
    if (end2.getTime() <= start1.getTime())
      j++;
    else if (end1.getTime() <= start2.getTime())
      i++;

    //overlap
    else {
      var newStart;
      var newEnd;
      if (end2.getTime() <= end1.getTime()) {
        j++;
        newEnd = end2;
      }
      else {
        i++;
        newEnd = end1;
      }
      newStart = new Date(Math.max(start1, start2));
      result.push([newStart, newEnd]);
    }
  }
  return result;
}

function invert(interval, epochStart, epochEnd) {
  var result = [];
  var start = epochStart;
  for (var i = 0; i < interval.length; i++) {
    var end = interval[i][0];
    if (start.getTime() < end.getTime())
      result.push([start, end]);
    start = interval[i][1];
  }
  if (start.getTime() < epochEnd.getTime())
    result.push([start, epochEnd]);
  return result;
}
/**
 * "substracts" interval2 from interval1
 * @param interval1
 * @param interval2
 * @returns Array{dateInterval}
 */
function andNotOp(interval1, interval2) {
  if (!(interval1 && interval1[0] && interval1[0][0])) {
    return [];
  }
  if (!(interval2 && interval2[0] && interval2[0][0])) {
    return interval1;
  }

  var epochStart = new Date(Math.min(interval1[0][0], interval2[0][0]));
  var epochEnd = new Date(Math.max(interval1[interval1.length - 1][1], interval2[interval2.length - 1][1]));
  interval2 = invert(interval2, epochStart, epochEnd);
  return andOp(interval1, interval2);
}

function validate(interval) {
  assert(interval instanceof  Array, "has to be array");
  for (var i = 0; i < interval.length; i++) {
    var element = interval[i];
    assert(element instanceof Array, "has to be array");
    assert(element[0] instanceof Date, "has to be date");
    assert(element[1] instanceof Date, "has to be date");
    assert(element[0].getTime() <= element[1].getTime(), "start has to be <= end");
  }
}

function splitSingleInterval(interval) {
  var res = [];
  var from = new Date(interval[0]);
  var to = new Date(interval[1]);
  var endOfDay = new Date(from.getFullYear(), from.getMonth(), from.getDate() + 1);
  while(endOfDay < to) {
    res.push([from, endOfDay]);
    from = endOfDay;
    endOfDay = new Date(from.getFullYear(), from.getMonth(), from.getDate() + 1);
  }
  res.push([from, to]);
  return res;
}

function splitMidnight(intervals) {
  var res = [];
  for (let interval of intervals) {
    var subRes = splitSingleInterval(interval);
    for (let sub of subRes) {
      res.push(sub);
    }
  }
  return res;
}

module.exports.standardFromTillDay = standardFromTillDay;
module.exports.cyclicFromTillDay = cyclicFromTillDay;
module.exports.singleDay = singleDay;
module.exports.orOp = orOp;
module.exports.andOp = andOp;
module.exports.andNotOp = andNotOp;
module.exports.mergeOverlaps = mergeOverlaps;
module.exports.sort = sort;
module.exports.dateSpan = dateSpan;
module.exports.validate = validate;
module.exports.splitMidnight = splitMidnight;
