"use strict";

function pretify(data) {
  function pretifyOption(val) {
    var ret;
    if (typeof val == 'object' && val[0] !== undefined) {
      ret = val[0];
    }
    else if (typeof val == 'string' || typeof val == 'number') {
      ret = val;
    }
    else {
      throw new Error('invalid option', val);
    }
    if (ret === "") ret = undefined;
    return ret;
  }

  function pretifyField(field) {
    var ret = {};
    for (let key of Object.keys(field)) {
      var val = pretifyOption(field[key]);
      if (val) ret[key] = val;
    }

    if (Object.keys(ret).length === 0) ret = undefined;
    return ret;
  }

  var ret = {};
  for (let key of Object.keys(data)) {
    let fields = data[key];
    if (fields) {
      var newFields = fields.map(function (field) {
        return pretifyField(field);
      }).filter(function (field) {
        return !!field;
      });
      ret[key] = newFields;
    }
  }
  return ret;
}

module.exports.pretify = pretify;
