var http = require('http');
var config = require('../config.json');

var hostname = config["restApiHost"];
var port = config["restApiPort"];

var blndMapping = {
  "Baden-Württemberg": "BW",
  "Niedersachsen": "NI",
  "Bayern": "BY",
  "Nordrhein-Westfalen": "NW",
  "Berlin": "BE",
  "Rheinland-Pfalz": "RP",
  "Brandenburg": "BB",
  "Saarland": "SL",
  "Bremen": "HB",
  "Sachsen": "SN",
  "Hamburg": "HH",
  "Sachsen-Anhalt": "ST",
  "Hessen": "HE",
  "Schleswig-Holstein": "SH",
  "Mecklenburg-Vorpommern": "MV",
  "Thüringen": "TH"
};

var headers = {
  "Content-Type": "application/json",
  "Connection": "keep-alive"
};
function request(path, cb) {
  var options = {
    hostname: hostname,
    port: port,
    path: path,
    method: 'GET',
    headers: headers
  };

  var callback = function (response) {
    var str = '';
    response.on('data', function (chunk) {
      str += chunk;
    });
    response.on('end', function () {
      cb(null, str);
    });
  };

  var req = http.request(options, callback);
  req.on("error", function (err) {
    err = new Error('Could not connect to: ' + hostname + path );
    cb(err);
  });
  req.setTimeout(500, function () {
    req.abort();
  });

  req.end();
}

module.exports.getBundesland = function(plz, cb) {
  var path = "/api/postleitzahlen/findone/?filter[where][plz]=" + plz;
  request(path, function (err, result) {
    if (err) return cb(err);
    var blnd;
    try {
      blnd = JSON.parse(result)['bundesland'];
    }
    catch (error) {
      return cb(err);
    }
    blnd = blndMapping[blnd];

    if (blnd === undefined)
      return cb(new Error("no bundesland found for plz " + plz));
    cb(null, blnd);
  });

};

module.exports.getKatholisch = function(plz, cb) {
  var path = '/api/relHolidays/findOne/?filter[where][plz]=' + plz;
  request(path, function (err, result) {
    if (err) return cb(err);
    var feiertag;
    try {
      feiertag = JSON.parse(result)['feiertag'];
    }
    catch (error) {
      return cb(err);
    }
    if (feiertag === undefined)
      return cb(new Error("no entry found in religion table for plz " + plz));
    cb(null, !!feiertag);
  })
};

/*getBundesland(4600, function (err, result) {
 console.log(err);
 console.log(result);
 });*/
/*getKatholisch(93047, function (err, result) {
 console.log(err);
 console.log(result);
 });*/
