var moment = require('moment');

var maybeString = "nach Absprache geöffnet";
var andMaybeString = "und nach Absprache geöffnet";
//var maybeString = "nag";
//var andMaybeString = "unag";

moment.locale("de");


function merge(a, b) {
  if (a.length === 0)
    return b;
  if (b.length === 0)
    return a;

  var c = [];
  var l1 = a.length;
  var l2 = b.length;
  var l = l1 + l2;
  var i = 0;
  var j = 0;
  for (var cnt = 0; cnt < l; cnt++) {
    if (i < l1 && (j >= l2 || a[i][0] - b[j][0] < 0)) {
      c.push(a[i++]);
    }
    else {
      c.push(b[j++]);
    }
  }
  return c;
}

function createWeekView(dataObj, now) {
  var noOfDays = 7;
//  var offset = 3;
  var offset = now.getDay() - 1;
  if (offset < 0) offset += 7;
  var startDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() - offset);
  var endDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() + noOfDays - offset);
  var oHours = transformData(dataObj, startDate, endDate);
  var tableWidth = getMaxNoOfItemsPerDay(oHours);
  var hasMaybe = hoursMaybe(oHours);
  var className = 'weekview';

  var content = '<div class="weekview-container"><table class="weekview-table weekview-' + (tableWidth + 2 + (hasMaybe ? 1 : 0)) + 'col">';
  content += '<tbody>';

  for (var i = 0; i < noOfDays; i++) {
    var day = oHours[i];
    content += '<tr class="weekview-tr">';
    var datString = formatDate(day.date);

    var cls = '';
    if (day.holiday) {
      cls += " weekview-holiday";
    }
    if (compareDate(day.date, now) == 0) {
      cls += " weekview-today";
    }
    if (day.date.getDay() == 0) {
      cls += " weekview-sunday";
    }
    else if (day.date.getDay() == 6) {
      cls += " weekview-saturday";
    }

    content += '<td class="weekview-td' + cls + '">' + datString[0]
      + '</td><td class="weekview-td' + cls + '">' + datString[1] + '</td>';

    for (var j = 0; j < day.oHours.length; j++) {
      var oHour = day.oHours[j];

      var elemCls = cls;
      if (oHour.maybe) {
        elemCls += " weekview-maybe";
      }

      content += '<td class="weekview-td weekview-filled' + elemCls + '">'
        + formatTime(oHour[0]) + " – " + formatTime(oHour[1]) + '</td>';
    }
    for (var j = day.oHours.length; j < tableWidth; j++) {
      content += '<td class="weekview-td weekview-empty' + cls + '"></td>';
    }


    if (hasMaybe) {
      var dayHasMaybe = day.oHoursMaybe.length > 0;
      var dayHasSure = day.oHours.length > 0;

      var displString = '';

      var tooltip = [];
      for (var j = 0; j < day.oHoursMaybe.length; j++) {
        var e = day.oHoursMaybe[j];
        tooltip.push(formatTime(e[0]) + " - " + formatTime(e[1]));
      }
      tooltip = tooltip.join("<br>");
      tooltip = ' data-uk-tooltip title="' + tooltip + '"';

      if (dayHasMaybe) {
        if (dayHasSure) {
          displString = andMaybeString;
        }
        else {
          displString = maybeString;
        }

        content += ('<td class="' + className + '-td '
        + className + '-maybe' + cls + '" ' + tooltip + '>' + displString + '</td>');
      }
      else {
        content += ('<td class="' + className + '-td ' + className + '-empty' + cls + '"></td>');
      }
    }


    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}

function hoursMaybe(oHours) {
  for (var i = 0; i < oHours.length; i++) {
    var obj = oHours[i];
    if (obj.oHoursMaybe.length > 0) return true;
  }
  return false;
}

function createWeekViewVerticalRaw(dataObj, now, className, offset, addDayOfWeek) {
  var noOfDays = 7;
  if (!offset) {
    offset = now.getDay() - 1;
    if (offset < 0) offset += 7;
  }

  var startDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() - offset);
  var endDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() + noOfDays - offset);
  var oHours = transformData(dataObj, startDate, endDate);

  var hasMaybe = hoursMaybe(oHours);

  var maxItems = getMaxNoOfItemsPerDay(oHours);

  var matrix = [];
  var rowInfo = [];

  for (var i = 0; i < noOfDays; i++) {
    var column = [];
    matrix.push(column);
    var day = oHours[i];

    var dayHasMaybe = day.oHoursMaybe.length > 0;
    var dayHasSure = day.oHours.length > 0;

    var cls = '';

    if (day.holiday) {
      cls += " " + className + "-holiday";
    }
    if (addDayOfWeek && compareDate(day.date, now) == 0) {
      cls += " " + className + "-today";
    }
    if (day.date.getDay() == 0) {
      cls += " " + className + "-sunday";
    }
    else if (day.date.getDay() == 6) {
      cls += " " + className + "-saturday";
    }

    var datString = formatDate(day.date);
    if (addDayOfWeek) {
      column.push('<td class="' + className + '-td-first' + cls + '">' + datString[0] + '</td>');
      column.push('<td class="' + className + '-td-date' + cls + '">' + datString[1] + '</td>');
    }
    else {
      column.push('<td class="' + className + '-td-date2' + cls + '">' + datString[1] + '</td>');
    }

    for (var j = 0; j < day.oHours.length; j++) {
      var oHour = day.oHours[j];

      var elemCls = cls;
      if (oHour.maybe) {
        elemCls += " weekview-v-maybe";
      }

      column.push('<td class="' + className + '-td ' + className + '-filled' + elemCls + '">'
        + formatTime(oHour[0]) + " – " + formatTime(oHour[1]) + '</td>');
    }
    for (var j = day.oHours.length; j < maxItems; j++) {
      column.push('<td class="' + className + '-td ' + className + '-empty' + cls + '"></td>');
    }
    if (hasMaybe) {
      var displString = '';

      var tooltip = [];
      for (var j = 0; j < day.oHoursMaybe.length; j++) {
        var e = day.oHoursMaybe[j];
        tooltip.push(formatTime(e[0]) + " - " + formatTime(e[1]));
      }
      tooltip = tooltip.join("<br>");
      tooltip = ' data-uk-tooltip title="' + tooltip + '"';

      if (dayHasMaybe) {
        if (dayHasSure) {
          displString = andMaybeString;
        }
        else {
          displString = maybeString;
        }
        if (!rowInfo[column.length]) rowInfo[column.length] = className + "-tr-maybe";

        column.push('<td class="' + className + '-td '
          + className + '-maybe' + cls + '" ' + tooltip + '>' + displString + '</td>');
      }
      else {
        column.push('<td class="' + className + '-td ' + className + '-empty' + cls + '"></td>');
      }
    }

  }

  return {matrix: matrix, rowInfo: rowInfo};
}

function createTwoWeekViewVertical(dataObj, now) {
  var className = 'two-weekview-v';
  var data = createWeekViewVerticalRaw(dataObj, now, className, 3, true);
  var data2 = createWeekViewVerticalRaw(dataObj, new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7), className, 3, false);
  var matrix = data.matrix;
  var matrix2 = data2.matrix;
  var rowInfo = data.rowInfo.concat(data2.rowInfo);

  for (var i = 0; i < matrix.length; i++) {
    matrix[i] = matrix[i].concat(matrix2[i]);
  }

  var content = '<div class="' + className + '-container"><table class="' + className + '-table">';
  content += '<tbody>';

  var jLim = matrix[0].length;
  var iLim = matrix.length;

  for (var j = 0; j < jLim; j++) {
    var trClass = className + '-tr';
    if (rowInfo[j]) trClass += " " + rowInfo[j];
    content += '<tr class="' + trClass + '">';
    for (var i = 0; i < iLim; i++) {
      content += matrix[i][j];
    }
    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}

function createWeekViewVertical(dataObj, now) {
  var className = 'weekview-v';
  var data = createWeekViewVerticalRaw(dataObj, now, className, null, true);
  var matrix = data.matrix;
  var rowInfo = data.rowInfo;

  var content = '<div class="' + className + '-container"><table class="' + className + '-table">';
  content += '<tbody>';

  var jLim = matrix[0].length;
  var iLim = matrix.length;

  for (var j = 0; j < jLim; j++) {
    var trClass = className + "-tr";
    if (rowInfo[j]) trClass += " " + rowInfo[j];
    content += '<tr class="' + trClass + '">';
    for (var i = 0; i < iLim; i++) {
      content += matrix[i][j];
    }
    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}

function createMonthView(dataObj, now, monthOffset) {

  var currentMonth = now.getMonth() + monthOffset;
  var startDate = new Date(now.getFullYear(), now.getMonth() + monthOffset, 1);
  var monthDate = new Date(startDate);

  if (startDate.getDay() === 0) {
    startDate.setDate(-5);
  }
  else {
    startDate.setDate(2 - startDate.getDay());
  }

  var endDate = new Date(now.getFullYear(), currentMonth + 1, 1);

  if (endDate.getDay() != 1)
    endDate.setDate(9 - endDate.getDay());

  currentMonth = currentMonth % 12;

  //TODO: only transform once for 3 month view
  var oHours = transformData(dataObj, startDate, endDate);

  var content = '<div class="monthview-maindiv">';
  content += '<div class="monthview-month">' + moment(monthDate).format("MMMM") + '</div>';
  content += '<table class="monthview-table"><thead class="monthview-thead"><tr>';

  for (var i = 0; i < 7; i++) {
    content += '<th class="monthview-th">' + moment(oHours[i].date).format("dd") + '</th>';
  }
  content += '</tr></thead>';

  for (var i = 0; i < oHours.length; i++) {
    var day = oHours[i];

    if (i % 7 == 0)
      content += '<tr class="monthview-tr">';

    if (day.date.getMonth() == currentMonth) {
      var cls = "";
      var tooltip;

      if (day.holiday) {
        cls += " monthview-holiday"
      }
      if (compareDate(day.date, now) == 0) {
        cls += " monthview-today";
      }

      if (day.oHours.length == 0) {
        tooltip = "";
        if (day.oHoursMaybe.length > 0)
          cls += " monthview-maybe";
        else
          cls += " monthview-empty";
      }
      else {
        cls += " monthview-filled";
        tooltip = [];
        for (var j = 0; j < day.oHours.length; j++) {
          var e = day.oHours[j];
          tooltip.push(formatTime(e[0]) + " - " + formatTime(e[1]));
        }
        tooltip = tooltip.join("<br>");
        tooltip = ' data-uk-tooltip title="' + tooltip + '"';
      }

      content += '<td class="monthview-td' + cls + '"' + tooltip + '>' + moment(day.date).format("D") + '</td>';
    }
    else {
      content += '<td class="monthview-td monthview-exclude"></td>';
    }

    if (i % 7 == 6)
      content += '</tr>';
  }

  content += '</table></div>';
  return content;
}

function create3MonthView(dataObj, now) {
  var content = '<div class="monthview-container">';
  for (var i = 0; i < 3; i++) {
    content += createMonthView(dataObj, now, i);
  }
  content += '</div>';
  return content;
}

function getView(dataObj, now) {
  var content = '<div class="view-container">';
  content += module.exports.week(dataObj, now);
  content += module.exports.weekV(dataObj, now);
  //content += module.exports.twoWeekV(dataObj, now);
  content += module.exports.threeMonth(dataObj, now);
  content += '</div>';
  return content;
}

function getMaxNoOfItemsPerDay(oHours) {
  var max = 0;
  for (var i = 0; i < oHours.length; i++) {
    if (oHours[i].oHours.length > max)
      max = oHours[i].oHours.length
  }
  return max;
}

function formatDate(date) {
  var mom = moment(date);
  return [mom.format("dddd"), mom.format("ll")];
}

function formatTime(date) {
  var hours = date.getHours().toString();
  var minutes = date.getMinutes().toString();
  if (hours.length < 2) hours = '0' + hours;
  if (minutes.length < 2) minutes = '0' + minutes;
  return hours + ':' + minutes;
//  return moment(date).format("HH:mm");
}



function weekViewData(dataObj, now) {
  var noOfDays = 7;
  var offset = now.getDay() - 1;

  var startDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() - offset);
  var endDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() + noOfDays - offset);
  var oHours = transformData(dataObj, startDate, endDate);

  function getHourSpan(oHours) {
    var hourMin = 24;
    var hourMax = 0;
    for (var i = 0; i < oHours.length; i++) {
      var dElem = oHours[i].oHours;
      for (var j = 0; j < dElem.length; j++) {
        var dElem0 = dElem[j][0].getHours();
        if(dElem0 < hourMin) hourMin = dElem0;
        var dElem1 = dElem[j][1].getHours();
        if(dElem1 > hourMax) hourMax = dElem1 + (dElem[j][1].getMinutes() > 0 ? 1 : 0)
      }
    }
    return [hourMin, hourMax];
  }

  var hourSpan = getHourSpan(oHours);




  return oHours;
}

function transformData(dataObj, startDate, endDate) {
  var data = dataObj.intervals.map(function (e) {
    return e;
    return {
      0: e[0],
      1: e[1],
      maybe: false
    }
  });

  var dataMaybe = dataObj.maybeIntervals.map(function (e) {
    return e;
    return {
      0: e[0],
      1: e[1],
      maybe: true
    }
  });

  var dataMerged = merge(data, dataMaybe);

  var holidays = dataObj.holidays;

  holidays = holidays.sort(function (a, b) {
    return a.getTime() - b.getTime();
  });

  var result = [];
  var curDate = new Date(startDate);

  var holidayIdx = 0;

  function dataIterator(data) {
    var idx = 0;
    var len = data.length;
    return {
      next: function () {
        var res = [];
        while (idx < len) {
          var comp = compareDate(data[idx][0], curDate);
          //TODO: split midnight
          if (comp < 0)
            idx++;
          else if (comp == 0) {
            res.push(data[idx]);
            idx++;
          }
          else break;
        }
        return res;
      }
    }
  }

  var dataIt = dataIterator(data);
  var dataMaybeIt = dataIterator(dataMaybe);
  var dataMergedIt = dataIterator(dataMerged);

  while (compareDate(curDate, endDate) < 0) {

    var oHours = dataIt.next();
    var oHoursMaybe = dataMaybeIt.next();
    //var oHoursMerged = dataMergedIt.next();

    var isHoliday = false;
    while (holidayIdx < holidays.length) {
      var comp = compareDate(holidays[holidayIdx], curDate);
      //TODO: split midnight
      if (comp < 0)
        holidayIdx++;
      else if (comp == 0) {
        isHoliday = true;
        holidayIdx++;
      }
      else break;
    }

    result.push({
      date: new Date(curDate),
      oHours: oHours,
      oHoursMaybe: oHoursMaybe,
      //oHoursMerged: oHoursMerged,
      holiday: isHoliday
    });
    curDate.setDate(curDate.getDate() + 1);
  }
  return result;
}

function compareDate(date1, date2) {
  var diff = date1.getFullYear() - date2.getFullYear();
  if (diff != 0) return diff;
  diff = date1.getMonth() - date2.getMonth();
  if (diff != 0) return diff;
  diff = date1.getDate() - date2.getDate();
  return diff;
}

function getPropperEpochSpan(now) {
  var epochStart = new Date(now.getFullYear(), now.getMonth(), -10);
  var epochEnd = new Date(now.getFullYear(), now.getMonth() + 3, 2);
  return [epochStart, epochEnd];
}

var tenMinutes = 10 * 60 * 1000;

function asString(dataObj, now) {
  const TWO_HOURS = 1000 * 3600 * 2;

  var data = dataObj.intervals;

  if (data.length == 0) {
    return {
      isOpen: false,
      text: ["Jetzt nicht geöffnet", "weitere Öffnungszeiten nicht bekannt"],
      status: "red"
    };
  }
//  var mNow = moment(now);
  var open = false;
  var nowT = now.getTime();
  var idx = 0;
  var firstText, secondText;
  var status = "red";

  while (idx < data.length && nowT >= data[idx][0].getTime()) {
    if (data[idx][1].getTime() >= nowT)
      open = true;
    idx++;
  }
  if (open) {
    idx--;
    if (data[idx][1].getTime() - nowT <= TWO_HOURS)
      firstText = "Jetzt noch geöffnet";
    else firstText = "Jetzt geöffnet";
    if (data[idx][1].getTime() - nowT <= tenMinutes)
      status = "yellow";
    else status = "green";

    secondText = "bis " + moment(data[idx][1]).format("LT");
  }
  else {
    firstText = "Jetzt nicht geöffnet";
    if (idx == data.length) {
      secondText = "nächster Öffnungstermin unbekannt";
      status = "red";
    }
    else {
      var nextM = moment(data[idx][0]);
      if (data[idx][0].getTime() - nowT <= TWO_HOURS) {
        secondText = "bald wieder geöffnet ab " + nextM.format("LT");
      }
      //uebermorgen wieder geoeffnet ab blabla im element[2]
      else if (compareDate(now, data[idx][0]) === 0) {
        secondText = "wieder geöffnet ab " + nextM.format("LT")
      }
      else {
        secondText = "wieder geöffnet am " + nextM.format("dddd") + ", " + nextM.format("l") + " ab " + nextM.format("LT");
      }
      if (data[idx][0].getTime() - nowT <= tenMinutes) {
        status = "yellow";
      }
    }
  }
  return {
    isOpen: open,
    text: [firstText, secondText].join(", "),
    status: status
  }
}

module.exports.asString = asString;
module.exports.week = createWeekView;
module.exports.weekV = createWeekViewVertical;
module.exports.twoWeekV = createTwoWeekViewVertical;
module.exports.threeMonth = create3MonthView;
module.exports.getView = getView;
module.exports.getPropperEpochSpan = getPropperEpochSpan;
module.exports.weekViewData = weekViewData;