function transform(x) {
  var res = [];
  for (var i = 0; i < x.length; i++) {
    res.push({
      from: x[i][0],
      to: x[i][1]
    })
  }
  return res;
}


var dateArray = require('./lib/dateArray');
var dateView = require('./lib/dateView');

function getOHIndex(info, today, cb) {
  today = new Date(today.getFullYear(), today.getMonth(), today.getDate());

  var epochSpan = [new Date(today.getFullYear(), today.getMonth(), today.getDate() - 7),
    new Date(today.getFullYear(), today.getMonth() + 1, today.getDate())];
  dateArray(epochSpan).getData(info, function (err, result) {
    if (err) return cb(err);
    var resultSure = result.intervals;
    var resultMaybe = result.maybeIntervals;

    var fResult = {
      sure: transform(resultSure),
      maybe: transform(resultMaybe)
      //sureToday: transform(resultSure.filter(function (elem) {
      //  return elem[0].getTime() >= today.getTime() && elem[1].getTime() <= tomorrow.getTime();
      //})),
      //maybeToday: transform(resultMaybe.filter(function (elem) {
      //  return elem[0].getTime() >= today.getTime() && elem[1].getTime() <= tomorrow.getTime();
      //})),
      //debugInfo: result.debugInfo
    };
    cb(null, fResult);
  })
}

function getOhView(info, now, cb) {
  var epocheSpan = dateView.getPropperEpochSpan(now);
  dateArray(epocheSpan).getData(info, function (err, dataObj) {
    if (err) return cb(null, err);

    var view = dateView.getView(dataObj, now);

    cb(null, res);
  })
}

function getShortString(info, now, cb) {

}

module.exports = {
  getOHIndex: getOHIndex,
  dateArray: dateArray,
  dateView: dateView
};

