var dateView = require('../lib/dateView');
var dateArray = require('../lib/dateArray');
var ejs = require('ejs');
var fs = require('fs');


var holidays = require('../lib/holidays');
var handler = {
  getBundesland: function(plz, cb) {
    cb(null, "BY");
  },
  getKatholisch: function (plz, cb) {
    cb(null, true);
  }
};
holidays.setRequestHandler(handler);


var now = new Date();


dateArray(dateView.getPropperEpochSpan(now)).getData(require('../mochaTests/testData/testHof.json'), 93047, function(err, data) {
  var view = dateView.getView(data, now, 93047);
  var template = fs.readFileSync('./template.ejs', {encoding: 'utf8'});
  view = ejs.render(template, {body: view});

  fs.writeFile('./testView/test.html', view, {encoding: 'utf8'}, function (err) {
    if (err) console.log(err);
    else  console.log("file saved");
  });
});
