var mysql = require('mysql');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');
var plz = 90473;

var connection = mysql.createConnection({
  host: 'localhost',
  user: 'read',
  password: 'read',
  database: 'regiostart'
});

connection.connect();

module.exports.getData = function (now, cb) {
  var epocheSpan = dateView.getPropperEpochSpan(now);
//  console.log(now);
//  console.log(epocheSpan);
//  dateArray.setEpocheSpan(epocheSpan);

  connection.query('SELECT name, elements FROM cms_zoo_item WHERE type = "company" LIMIT 50', function (err, rows) {
    var result = [];
    var cnt = 0;
    var iters = rows.length;
    for (var i = 0; i < rows.length; i++) {
      var obj = JSON.parse(rows[i].elements);
      (function() {
        var name = rows[i].name;

        dateArray(epocheSpan).getData(obj, plz, function (err, data) {
          if(err) {
            console.log(name, err);
          }

          else if (data.length > 0) {
            cnt++;
            var view = dateView.getView(data, now);
            result.push('<div class="name">' + name + "</div> " + view);
          }
          if (--iters == 0) {
            console.log("Count: %d", cnt);
            cb(result.join('<br>'));
          }
        });
      })();
    }
  });
};



