function compareFT(from, till) {
  if(from.h == till.h)
    return from.m - till.m;
  else
    return from.h - till.h
}

function transformTill(from, till) {
  if(compareFT(from, till) > 0) {
    return {h: till.h + 24, m: till.m}
  }
  else return till;
}

function _cyclicInterval(from, until, interval, epochStart, epochEnd) {
  if(from >= until) throw new Error("startDate cant be greater than endDate");
  var resultArray = [];
  for(var offset = 0; until.getTime() + offset < epochEnd.getTime(); offset += interval) {
    resultArray.push([new Date(from.getTime() + offset), new Date(until.getTime() + offset)]);
  }
  return resultArray;
}

function _standard(day, timeFrom, timeUntil, epochStart, epochEnd, distanceDays) {
  var dayDiff = day - epochStart.getDay();
  if(dayDiff < 0)
    dayDiff += 7;

  var startDate = new Date(epochStart.getFullYear(), epochStart.getMonth(),
      epochStart.getDate() + dayDiff, timeFrom.h, timeFrom.m);
  var endDate = new Date(epochStart.getFullYear(), epochStart.getMonth(),
      epochStart.getDate() + dayDiff, timeUntil.h, timeUntil.m);

  return _cyclicInterval(startDate, endDate, distanceDays * 24 * 3600000, epochStart, epochEnd);
}

function standardFromTillDay(dayFrom, dayTill, timeFrom, timeUntil, epochStart, epochEnd, daysDistance) {
  timeUntil = transformTill(timeFrom, timeUntil);

  var firstDays = _standard(dayFrom, timeFrom, timeUntil, epochStart, epochEnd, daysDistance);
  var result = firstDays.slice();

  for(var offset = 1; offset <= dayTill - dayFrom; offset++) {
    for(var i = 0; i < firstDays.length; i++) {
      var start = new Date(firstDays[i][0]);
      var end = new Date(firstDays[i][1]);
      start.setDate(start.getDate() + offset);
      end.setDate(end.getDate() + offset);
      if(end <= epochEnd)
        result.push([start, end]);
    }
  }

  result = sortDateIntervals(result);
  return result;
}

function cyclic(day, noInMonth, timeFrom, timeUntil, epochStart, epochEnd) {
  var result = [];
  epochStart = new Date(epochStart);

  while(true) {
    var startDate = _getNextNoInMonthOccurence(day, epochStart, noInMonth);
    startDate.setHours(timeFrom.h);
    startDate.setMinutes(timeFrom.m);
    var endDate = new Date(startDate);
    endDate.setHours(timeUntil.h);
    endDate.setMinutes(timeUntil.m);
    if(endDate > epochEnd)
      break;
    else {
      result.push([startDate, endDate]);
      epochStart = new Date(endDate);
      epochStart.setDate(epochStart.getDate() + 1);
    }
  }
  return result;
}

function cyclicFromTillDay(dayFrom, dayTill, noInMonth, timeFrom, timeUntil, epochStart, epochEnd) {
  timeUntil = transformTill(timeFrom, timeUntil);
  var result = [];
  epochStart = new Date(epochStart);

  while(true) {
    var startDate = _getNextNoInMonthOccurence(dayFrom, epochStart, noInMonth);
    startDate.setHours(timeFrom.h);
    startDate.setMinutes(timeFrom.m);
    var endDate = new Date(startDate);
    endDate.setHours(timeUntil.h);
    endDate.setMinutes(timeUntil.m);
    if(endDate > epochEnd)
      break;
    else {
      result.push([startDate, endDate]);
      epochStart = new Date(endDate);
      epochStart.setDate(epochStart.getDate() + 1);
      for(var offset = 1; offset <= dayTill - dayFrom; offset++) {
        startDate = new Date(startDate);
        endDate = new Date(endDate);
        startDate.setDate(startDate.getDate() + 1);
        endDate.setDate(endDate.getDate() + 1);
        if(endDate <= epochEnd)
          result.push([startDate, endDate]);
        else break;
      }
    }
  }
  return result;
}

function _cyclicFromTillDayOld(dayFrom, dayTill, noInMonth, timeFrom, timeUntil, epochStart, epochEnd) {
  var firstDays = cyclic(dayFrom, noInMonth, timeFrom, timeUntil, epochStart, epochEnd);
  var result = firstDays.slice();

  for(var offset = 1; offset <= dayTill - dayFrom; offset++) {
    for(var i = 0; i < firstDays.length; i++) {
      var start = new Date(firstDays[i][0]);
      var end = new Date(firstDays[i][1]);
      start.setDate(start.getDate() + offset);
      end.setDate(end.getDate() + offset);
      if(end <= epochEnd)
        result.push([start, end]);
    }
  }
  sortDateIntervals(result);
  return result;
}

function _getNextNoInMonthOccurence(day, startDate, noInMonth) {
  startDate = new Date(startDate);

  var _noInMonth;
  if(noInMonth == -1) {
    _noInMonth = 1;
    startDate.setDate(startDate.getDate() + 7);
  }
  else {
    _noInMonth = noInMonth;
  }

  var dayDiff = day - startDate.getDay();
  if(dayDiff < 0) dayDiff += 7;
  startDate.setDate(startDate.getDate() + dayDiff);

  var currentNoInMonth = Math.ceil(startDate.getDate() / 7);
  while(currentNoInMonth != _noInMonth) {
    startDate = new Date(startDate.getTime() + 7 * 24 * 3600000);
    currentNoInMonth = Math.ceil(startDate.getDate() / 7);
  }

  if(noInMonth == -1) {
    startDate.setDate(startDate.getDate() - 7);
  }
  return startDate;
}

function singleDay(date) {
  var startDate = new Date(date.getFullYear(), date.getMonth(), date.getDate());
  var endDate = new Date(startDate);
  endDate.setDate(endDate.getDate() + 1);
  return [[startDate, endDate]];
}


function orOperator(intervals) {
  var result = [];
  for(var i = 0; i < intervals.length; i++) {
    result = result.concat(intervals[i]);
  }
  sortDateIntervals(result);
  return result;
}

function sortDateIntervals(intervals) {
  intervals.sort(function(a, b) {
    return a[0] - b[0];
  });
  return intervals;
}

function mergeOverlaps(interval) {
  var i = 0;
  while(i < interval.length - 1) {
    var endFirst = interval[i][1];
    var startSecond = interval[i + 1][0];
    var endSecond = interval[i + 1][1];
    if(endFirst >= startSecond) {
      interval.splice(i + 1, 1);
      interval[i][1] = endSecond;
    }
    else i++;
  }
  return interval;
}

function andOperator(interval1, interval2) {
  var result = [];

  var i = 0;
  var j = 0;
  while(i < interval1.length && j < interval2.length) {
    var start1 = interval1[i][0];
    var end1 = interval1[i][1];
    var start2 = interval2[j][0];
    var end2 = interval2[j][1];

    //no overlap
    if(end2 <= start1)
      j++;
    else if(end1 <= start2)
      i++;

    //overlap
    else {
      var newStart;
      var newEnd;
      if(end2 <= end1) {
        j++;
        newEnd = end2;
      }
      else {
        i++;
        newEnd = end1;
      }
      newStart = new Date(Math.max(start1, start2));
      result.push([newStart, newEnd]);
    }
  }
  return result;
}

function invert(interval, epochStart, epochEnd) {
  var result = [];
  var start = epochStart;
  for(var i = 0; i < interval.length; i++) {
    var end = interval[i][0];
    if(start < end)
      result.push([start, end]);
    start = interval[i][1];
  }
  if(start < epochEnd)
    result.push([start, epochEnd]);
  return result;
}

function andNotOperator(interval1, interval2) {
  var epochStart = new Date(Math.min(interval1[0][0], interval2[0][0]));
  var epochEnd = new Date(Math.min(interval1[interval1.length - 1][1], interval2[interval2.length - 1][1]));

  interval2 = invert(interval2, epochStart, epochEnd);
  return andOperator(interval1, interval2);
}

module.exports.standardFromTillDay = standardFromTillDay;
module.exports.cyclicFromTillDay = cyclicFromTillDay;
module.exports.singleDay = singleDay;
module.exports.orOperator = orOperator;
module.exports.andOperator = andOperator;
module.exports.andNotOperator = andNotOperator;
module.exports.mergeOverlaps = mergeOverlaps;