var tmUtils = require('./timeUtils');

var now = new Date();

var _epochStart = new Date();
_epochStart.setDate(_epochStart.getDate() - 14);
var _epochEnd = new Date(_epochStart.getTime() + 60 * 24 * 3600000);


function calculateOpeningHours(json) {
  var jsonIncl = json["include"];
  for(var key in jsonIncl) {
    var dateA = getOpeningHours(jsonIncl[key]);
    console.log(key, dateA);
  }

}

function getDaySpan(dayoption) {
  if(dayoption < 7) return [dayoption, dayoption];
  switch(dayoption) {
    case 7:
      return [0, 0];
    case 8:
      return [0, 7];
    case 9:
      return [1, 5];
    case 10:
      return [1, 6];
    default:
      throw "Invalid day option";
  }
}

function parseTime(time) {
  var split = time.split(":");
  return {
    h: parseInt(split[0]),
    m: parseInt(split[1])
  }
}

function parseDate(date) {
  if(date.length == 0)
    return null;

  var year = now.getFullYear();
  var split = date.split(".");
  var month = parseInt(split[1]);
  var day = parseInt(split[0]);
  return new Date(year, month, day);
}


function getOpeningHours(json) {
  var dayoption = parseInt(json["dayoption"]["0"]);
  var daySpan = getDaySpan(dayoption);
  var option = json["option"]["0"];

  var startDate = parseDate(json["opening_day_from"]) || _epochStart;
  var endDate = parseDate(json["opening_day_to"]) || _epochEnd;

  var timeFrom = parseTime(json["opening_from"]);
  var timeTill = parseTime(json["opening_to"]);

  switch(option) {
    case "default":
      return tmUtils.standardFromTillDay(daySpan[0], daySpan[1], timeFrom, timeTill, _epochStart, _epochEnd, 7);
    case "season":
      return tmUtils.standardFromTillDay(daySpan[0], daySpan[1], timeFrom, timeTill, startDate, endDate, 7);
    case "repeatable":
      var repeatOption = parseInt(json["repeatoption"]["0"]);
      var noInMonth;
      if(repeatOption <= 4) noInMonth = repeatOption;
      else if(repeatOption == 30) noInMonth = -1;

      if(noInMonth)
        return tmUtils.cyclicFromTillDay(daySpan[0], daySpan[1], noInMonth,timeFrom, timeTill, startDate, endDate);

      switch (repeatOption) {
        case 14:
        case 21:
        case 28:
          return tmUtils.standardFromTillDay(daySpan[0], daySpan[1], timeFrom, timeTill, startDate, endDate, repeatOption);
        default:
          throw "invalid repeat option";
      }
  }
}

calculateOpeningHours(require('./testData/data.json'));