var moment = require('moment');

moment.lang("de");

var twoHours = 1000 * 3600 * 2;

function createWeekView(dataObj, now) {
  var data = dataObj.intervals;
  var holidays = dataObj.holidays;
  var noOfDays = 7;
//  var offset = 3;
  var offset = now.getDay() - 1;
  if(offset < 0) offset += 7;
  var startDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() - offset);
  var endDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() + noOfDays - offset);
  var oHours = transformData(data, startDate, endDate);
  var maxNumber = getMaxNoOfItemsPerDay(oHours);
  var tableWidth = maxNumber;

  var content = '<div class="weekview-container"><table class="weekview-table weekview-' + (tableWidth + 2) + 'col">';
  content += '<tbody>';

  for (var i = 0; i < noOfDays; i++) {
    var day = oHours[i];
    content += '<tr class="weekview-tr">';
    var datString = formatDate(day.date);

    var cls = '';
    if (dayInHolidays(day.date, holidays)) {
      cls += " weekview-holiday";
    }
    if (compareDate(day.date, now) == 0) {
      cls += " weekview-today";
    }
    if(day.date.getDay() == 0) {
      cls += " weekview-sunday";
    }
    else if(day.date.getDay() == 6) {
      cls += " weekview-saturday";
    }

    content += '<td class="weekview-td' + cls + '">' + datString[0] + '</td><td class="weekview-td' + cls + '">' + datString[1] + '</td>';

    for (var j = 0; j < day.oHours.length; j++) {
      var oHour = day.oHours[j];
      content += '<td class="weekview-td weekview-filled' + cls + '">' + formatTime(oHour[0]) + " – " + formatTime(oHour[1]) + '</td>';
    }
    for (var j = day.oHours.length; j < tableWidth; j++) {
      content += '<td class="weekview-td weekview-empty' + cls + '"></td>';
    }
    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}

function createWeekViewVerticalRaw(dataObj, now, className, offset, addDayOfWeek) {
  var data = dataObj.intervals;
  var holidays = dataObj.holidays;
  var noOfDays = 7;

  if(!offset) {
    offset = now.getDay() - 1;
    if(offset < 0) offset += 7;
  }

  var startDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() - offset);
  var endDate = new Date(now.getFullYear(), now.getMonth(), now.getDate() + noOfDays - offset);
  var oHours = transformData(data, startDate, endDate);
  var maxItems = getMaxNoOfItemsPerDay(oHours);

  var columns = [];

  for (var i = 0; i < noOfDays; i++) {
    var column = [];
    columns.push(column);
    var day = oHours[i];

    var cls = '';
    if (dayInHolidays(day.date, holidays)) {
      cls += " " + className + "-holiday";
    }
    if (compareDate(day.date, now) == 0) {
      cls += " " + className + "-today";
    }
    if(day.date.getDay() == 0) {
      cls += " " + className + "-sunday";
    }
    else if(day.date.getDay() == 6) {
      cls += " " + className + "-saturday";
    }

    var datString = formatDate(day.date);
    if(addDayOfWeek) {
      column.push('<td class="' + className + '-td-first' + cls + '">' + datString[0] + '</td>');
      column.push('<td class="' + className + '-td-date' + cls + '">' + datString[1] + '</td>');
    }
    else {
      column.push('<td class="' + className + '-td-date2' + cls + '">' + datString[1] + '</td>');
    }

    for (var j = 0; j < day.oHours.length; j++) {
      var oHour = day.oHours[j];
      column.push('<td class="' + className + '-td ' + className + '-filled' + cls + '">' + formatTime(oHour[0]) + " – " + formatTime(oHour[1]) + '</td>');
    }
    for (var j = day.oHours.length; j < maxItems; j++) {
      column.push('<td class="' + className + '-td ' + className + '-empty' + cls + '"></td>');
    }
  }

  return columns;


}

function createTwoWeekViewVertical(dataObj, now) {
  var className = 'two-weekview-v';
  var columns = createWeekViewVerticalRaw(dataObj, now, className, 3, true);
  var columns2 = createWeekViewVerticalRaw(dataObj, new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7), className, 3, false);

  for (var i = 0; i < columns.length; i++) {
    columns[i] = columns[i].concat(columns2[i]);
  }

  var content = '<div class="' + className + '-container"><table class="' + className + '-table">';
  content += '<tbody>';

  var jLim = columns[0].length;
  var iLim = columns.length;

  for (var j = 0; j < jLim; j++) {
    content += '<tr class="' + className + '-tr">';
    for (var i = 0; i < iLim; i++) {
      content += columns[i][j];
    }
    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}
function createWeekViewVertical(dataObj, now) {
  var className = 'weekview-v';
  var columns = createWeekViewVerticalRaw(dataObj, now, className, null, true);

  var content = '<div class="' + className + '-container"><table class="' + className + '-table">';
  content += '<tbody>';

  var jLim = columns[0].length;
  var iLim = columns.length;

  for (var j = 0; j < jLim; j++) {
    content += '<tr class="' + className + '-tr">';
    for (var i = 0; i < iLim; i++) {
      content += columns[i][j];
    }
    content += '</tr>';
  }

  content += '</tbody>';
  content += '</table></div>';
  return content;
}


function dayInHolidays(day, holidays) {
  for (var i = 0; i < holidays.length; i++) {
    if (compareDate(day, holidays[i]) == 0) {
      return true;
    }
  }
  return false;
}

function createMonthView(dataObj, now, monthOffset) {
  var data = dataObj.intervals;
  var holidays = dataObj.holidays;

  var currentMonth = now.getMonth() + monthOffset;
  var startDate = new Date(now.getFullYear(), currentMonth, 1);
  var monthDate = new Date(startDate);

  startDate.setDate(2 - startDate.getDay());

  var endDate = new Date(now.getFullYear(), currentMonth + 1, 1);
  if (endDate.getDay() != 1)
    endDate.setDate(9 - endDate.getDay());

  //TODO: only transform once for 3 month view
  var oHours = transformData(data, startDate, endDate);

  var content = '<div class="monthview-maindiv">';
  content += '<div class="monthview-month">' + moment(monthDate).format("MMMM") + '</div>';
  content += '<table class="monthview-table"><thead class="monthview-thead"><tr>';

  for (var i = 0; i < 7; i++) {
    content += '<th class="monthview-th">' + moment(oHours[i].date).format("dd") + '</th>';
  }
  content += '</tr></thead>';

  for (var i = 0; i < oHours.length; i++) {
    var day = oHours[i];

    if (i % 7 == 0)
      content += '<tr class="monthview-tr">';

    if (day.date.getMonth() == currentMonth) {
      var cls = "";
      var tooltip;
      if (dayInHolidays(day.date, holidays)) {
        cls += " monthview-holiday"
      }
      if (compareDate(day.date, now) == 0) {
        cls += " monthview-today";
      }

      if (day.oHours.length == 0) {
        tooltip = "";
        cls += " monthview-empty";
      }
      else {
        cls += " monthview-filled";
        tooltip = [];
        for (var j = 0; j < day.oHours.length; j++) {
          var e = day.oHours[j];
          tooltip.push(formatTime(e[0]) + " - " + formatTime(e[1]));
        }
        tooltip = tooltip.join("<br>");
        tooltip = ' data-uk-tooltip title="' + tooltip + '"';
      }

      content += '<td class="monthview-td' + cls + '"' + tooltip + '>' + moment(day.date).format("D") + '</td>';
    }
    else {
      content += '<td class="monthview-td monthview-exclude"></td>';
    }

    if (i % 7 == 6)
      content += '</tr>';
  }

  content += '</table></div>';
  return content;
}

function create3MonthView(dataObj, now) {
  var content = '<div class="monthview-container">';
  for (var i = 0; i < 3; i++) {
    content += createMonthView(dataObj, now, i);
  }
  content += '</div>';
  return content;
}

function getView(dataObj, now) {
  var content = '<div class="view-container">';
  content += module.exports.weekView(dataObj, now);
  content += module.exports.weekViewV(dataObj, now);
  content += module.exports.twoWeekViewV(dataObj, now);
  content += module.exports.monthView(dataObj, now);
  content += '</div>';
  return content;
}

function getMaxNoOfItemsPerDay(oHours) {
  var max = 0;
  for (var i = 0; i < oHours.length; i++) {
    if (oHours[i].oHours.length > max)
      max = oHours[i].oHours.length
  }
  return max;
}

function formatDate(date) {
  var mom = moment(date);
  return [mom.format("dddd"), mom.format("ll") ];
}

function formatTime(date) {
  var hours = date.getHours().toString();
  var minutes = date.getMinutes().toString();
  if (hours.length < 2) hours = '0' + hours;
  if (minutes.length < 2) minutes = '0' + minutes;
  return hours + ':' + minutes;
//  return moment(date).format("HH:mm");
}

function transformData(data, startDate, endDate) {
  var dataIdx = 0;
  var result = [];
  var curDate = new Date(startDate);
  while (compareDate(curDate, endDate) < 0) {
    var oHours = [];
    while (dataIdx < data.length) {
      var comp = compareDate(data[dataIdx][0], curDate);
      //TODO: split midnight
      if (comp < 0)
        dataIdx++;
      else if (comp == 0) {
        oHours.push(data[dataIdx]);
        dataIdx++;
      }
      else break;
    }
    result.push({
      date: new Date(curDate),
      oHours: oHours
    });
    curDate.setDate(curDate.getDate() + 1);
  }
  return result;
}

function compareDate(date1, date2) {
  var diff = date1.getFullYear() - date2.getFullYear();
  if (diff != 0) return diff;
  diff = date1.getMonth() - date2.getMonth();
  if (diff != 0) return diff;
  diff = date1.getDate() - date2.getDate();
  return diff;
}

function getPropperEpochSpan(now) {
  var epochStart = new Date(now.getFullYear(), now.getMonth(), -10);
  var epochEnd = new Date(now.getFullYear(), now.getMonth() + 3, 1);
  return [epochStart, epochEnd];
}

function asString(data, now) {
  data = data.intervals;
  if (data.length == 0) {
    return {
      isOpen: false,
      asString: ["Jetzt nicht geöffnet", "nächster Öffnungstermin unbekannt"]
    };
  }
//  var mNow = moment(now);
  var open = false;
  var nowT = now.getTime();
  var idx = 0;
  var first, second;

  while (nowT >= data[idx][0].getTime() && idx < data.length) {
    if (data[idx][1].getTime() >= nowT)
      open = true;
    idx++;
  }
  if (open) {
    idx--;
    if(data[idx][1].getTime() - nowT <= twoHours)
      first = "Jetzt noch geöffnet";
    else first = "Jetzt geöffnet";

    second = "bis " + moment(data[idx][1]).format("LT");
  }
  else {
    first = "Jetzt nicht geöffnet";
    if (idx == data.length) {
      second = "nächster Öffnungstermin unbekannt";
    }
    else {
      var nextM = moment(data[idx][0]);
      if(data[idx][0].getTime() - nowT <= twoHours) {
        second = "bald wieder geöffnet ab " + nextM.format("LT");
      }
      else if(compareDate(now, data[idx][0]) === 0) {
        second = "wieder geöffnet ab " + nextM.format("LT")
      }
      else {
        second = "wieder geöffnet am " + nextM.format("dddd") + ", " + nextM.format("l") + " ab " + nextM.format("LT");
      }
    }
  }
  return {
    isOpen: open,
    asString: [first, second]
  }
}

module.exports.asString = asString;
module.exports.weekView = createWeekView;
module.exports.weekViewV = createWeekViewVertical;
module.exports.twoWeekViewV = createTwoWeekViewVertical;
module.exports.monthView = create3MonthView;
module.exports.getView = getView;
module.exports.getPropperEpochSpan = getPropperEpochSpan;