var mysql = require('mysql');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');
var moment = require('moment');
var ejs = require('ejs');
var renderView = require('../lib/renderView');

var fs = require('fs');

var holidays = require('../lib/holidays');
holidays.setTestHandler();
Date.prototype.toISOString = Date.prototype.toLocaleString;

var connection = mysql.createConnection({
  host: 'localhost',
  user: 'root',
  password: 'bla',
  database: 'dev_regionalkauf_cms'
});

connection.connect();

var dateSpan = [new Date(2014, 0, 0), new Date(2015, 0, 0)];
var now = new Date(2014, 7, 10);
console.log(dateSpan);
dateArray = dateArray(dateSpan);

var extractionDate = moment().format('YYYYMMDD');

//var ids = [2650, 2422, 3];
//var ids = [2422, 1627, 2650, 864];
var ids = [468];
connection.query('SELECT id, name, elements, type FROM cms_zoo_item WHERE id  in ('+ ids.join(', ')+')', function (err, rows) {
  for (var i = 0; i < rows.length; i++) {
    var id = rows[i].id;
    var json = JSON.parse(rows[i].elements);
    dateArray.getData(json, 93161, function (err, result) {
      if(err) {
        console.error(id, err);
      }
      else {
//        result.maybeIntervals = [];
      }
      fs.writeFileSync('../testData/input/' + extractionDate + '_' + id + '.json', JSON.stringify(json));
      var validation = err ? {error: err.toString()} : result;
      fs.writeFileSync('../testData/validation/' + extractionDate + '_' + id + '.json', JSON.stringify(validation));
      if(!err) {
        var view = dateView.getView(result, now);
        view = renderView.render(view);
        fs.writeFileSync('../testData/validation/' + extractionDate + '_' + id + '.html', view);
      }

    });
  }
});

connection.end();