var mysql = require('mysql');
var dateArray = require('../lib/dateArray');
var dateView = require('../lib/dateView');

var fs = require('fs');
var tmUtils = require('../lib/timeUtils');

var connection = mysql.createConnection({
  host: 'localhost',
  user: 'read',
  password: 'read',
  database: 'regiostart'
});

connection.connect();

connection.query('SELECT name, elements FROM cms_zoo_item WHERE type = "company"', function (err, rows) {
  var cntGood = 0;
  var cntBad = 0;
  for (var i = 0; i < rows.length; i++) {
    var json = rows[i].elements;
    var obj = JSON.parse(json);
    var name = rows[i].name;
    try {
      var result = dateArray.getData(obj);
      tmUtils.validate(result);
    }
    catch (err) {
      console.log(err, name);
      var result = [];
      fs.writeFileSync(process.env["HOME"] + '/Desktop/oHours/invalid/' + name + '.json', json);
    }

    if (result.length > 0) {
//      console.log(name);
//      console.log(JSON.stringify(result));
      cntGood++;
    }
    else {
      cntBad++;
    }
  }
  console.log(cntGood, cntBad);
});

connection.end();