"use strict";

const thumbgen = require('lib/index');
const Promise = require('bluebird');

function generateThumbnailTooltip(options) {

  thumbgen(options.pathtovideo, {
    output: options.output || './tmp/vtt/myVTT.vtt',
    assetsDirectory: options.assetsDirectory,
    size: {
      width: options.width,
      height: options.height
    } || null,
    timemarks: options.timemarks || null,
    numThumbnails: options.numThumbnails || 0,
    secondsPerThumbnail: options.secondsPerThumbnail || 5,
    framesPerThumbnail: options.framesPerThumbnail || 0,
    spritesheet: options.spritesheet || true,
    spriteSheetName: options.spriteSheetName || 'thumbnails',
  }, function (err, metadata) {
    if (err) {
      throw err
    }
  });


}

module.exports = generateThumbnailTooltip;


