## API

### thumbgen(source, options, callback)

Create thumbnails (and optionally pack them into spritesheet) and create WebVTT file for file(s). Options are described below

## Options

* **output** defaults to `"SOURCE_DIR/SOURCE_BASENAME.vtt"`

    * WebVTT filename

* **assetsDirectory** defaults to `"SOURCE_BASENAME"`

    * Name of folder which keeps thumbnails or spritesheet.

* **size** defaults to `null`

    * Size of generated thumbnails. If not specified original video stream `width` and `height` will be used. If only `width` or `height` is specified other will be computed according to source video ratio.

* **size.width** defaults to `SOURCE_WIDTH`  

    * Read above

* **size.height** defaults to `SOURCE_HEIGHT`  

    * Read above

* **timemarks** defaults to `null`

    * Array with timemarks in seconds. E.g. ['123.123', '345.345']

* **numThumbnails** defaults to `0`

    * Number of thumbnails to generate. Used in opposite to `timemarks`. Each thumbnail moment is calculated as `source_duration * 0.9 / numThumbnails`.

* **secondsPerThumbnail** defaults to `5`

    * If specified thumbnails will be generated each `secondsPerThumbnail` seconds.

* **framesPerThumbnail** defaults to `0`

    * If specified thumbnails will be generated each `framesPerThumbnail` frames.

* **spritesheet** defaults to `true`

    * Generate spritesheet or not.

* **spriteSheetName** defaults to `"thumbnails"`

    * Spritesheet file name

