# Ubuntu 16.04 Setup

# 1. Initial setup

Log dich über deine Konsole auf dem Server ein mit ssh root@\<serveraddress>. Er wird dich nun nach einem Passwort fragen. Gebe das Passwort ein damit du nun als ROOT auf deinem Server eingeloggt bist.

## 1.1 User erstellen

Als erstes führen wir als ROOT
```
adduser <username>
```
aus. Nun musst du ein Passwort eingeben. Dies wird das Login Passwort für deinen neuen User. Wenn du das neue Passwort zwei mal eingegeben hast, kommen folgende Informationen, die du mit `Enter` bestätigen kannst.
```
Enter the new value, or press ENTER for the default
	Full Name []: 
	Room Number []: 
	Work Phone []: 
	Home Phone []: 
	Other []: 
```
Nun haben wir einen neuen User erstellt. DIesem User solltest du auch zur `sudo` Gruppe hinzufügen, damit man in Zukunft auch mit diesem User arbeiten kann.
Dies erledigt folgender Befehl:
```
usermod -aG sudo <username>
```
Nachdem dies nun erledigt ist, können wir uns als ROOT ausloggen und auf unserer Heimkonsole 
```
ssh <username>@<serveraddress>
```
eingeben. Nun kannst du dein Passwort eingeben und solltest eingeloggt sein.
>Falls du an dieser Stelle nicht eingeloggt bist wende dich bitte an einen Mitarbeiter oder versuche die Schritte nochmals zu wiederholen

## 1.2 SSH authentifizierung durch ssh-key

Keiner kann Passwörter leiden, deswegen bauen wir uns einen Zugang über SSH-Key Erkennung. Dazu erstellen wir in unseren "Home" Verzeichnis den Ordner `.ssh` und legen dort die Datei `authorized_keys` an. Dort fügst du deinen Public SSH-Key ein.
>Wenn du an dieser Stelle nicht weißt was ein SSH Key ist, wie man diesen erstellt und wo man den findet, Frage deinen Vorgesetzten nach einer neuen Aufgabe

Nun kannst du testen ob du dich mit `ssh <username>@<serveraddress>` einloggen kannst ohne ein Passwort zu benutzen.  

## 1.3 ROOT und Passwort Login deaktivieren

Jetzt werden wir zusehen das wir den Login durch ROOT verhindern, denn dies kann schnell zur Sicherheitslücke werden.  
>In diesem setup werde ich ausschließlich vim als Editor verwenden. Wenn es dir lieber ist einen anderen Editor zu verwenden, wie z.B. nano, kannst du dies machen

Um zu testen ob wir auch ROOT-Rechte haben werden wir diese gleich mal verwenden indem wir die sshd_config bearbeiten. Dies geschieht mit:
```
vim /etc/ssh/sshd_config
```
Nun musst du Sicherstellen das folgende Zeilen in der Datei vorhanden sind. Wenn nicht änder diese. 
```
PermitRootLogin no
PasswordAuthentication no
```  

## 1.4 Firewall einrichten

Wir loggen erstmal von unserem User auf ROOT um mithilfe von
```
sudo su -
```
Hier muss dein Passwort eingegeben werden. DIes lässt sich nicht ändern.  
nachdem du dich nun als ROOT angemeldet hast können wir die eine Simple Firewall installieren.
```
apt-get install ufw
```

Verschiedene Anwendungen können sich in UFW eintragen, wenn du sie installierst. Dies erlaubt es UFW die Anwendungen zu steuern. OpenSSH, die Anwendung mit der wir uns auf den Server verbinden, hat schon einen Eintrag in UFW.

Die Liste kann man sehen wenn folgendes eingibst:
```
sudo ufw app list
```
```
Output:

Available applications:
  OpenSSH
```

Nun musst du sicherstellen das die Firewall auch SSH Zugänge zulässt. Ansonsten sperrst du dich aus dem Server aus.
Also gibst du folgendes ein:
```
sudo ufw allow OpenSSH
```
Nun musst du noch noch die Firewall einschalten mit:
```
sudo ufw enable
````
Nun bestätige noch das aktivieren der Firewall mit "y".  
Nun schau nach ob SSH noch eingeschaltet ist mit:
```
sudo ufw status
````
```
Output
Status: active

To                         Action      From
--                         ------      ----
OpenSSH                    ALLOW       Anywhere
OpenSSH (v6)               ALLOW       Anywhere (v6)
```
Merk dir bitte wenn du weitere Dienste installierst das du die Firewall updaten musst.

# 2 Dienste die der Server braucht

## 2.1 PHP

>PHP wird nur benötigt wenn du auch mit einem PHP-CMS arbeitest, wie z.B. Wordpress. Ansonsten brauchst du es nicht und du kannst direkt mit 2.2 weiter machen.

Für dieses setup benutz ich PHP 7.1. Wenn deine Seite eine andere PHP Version benutzt kann dir [diese Seite](http://google.com) weiterhelfen.  

### 2.1.1 Python

Damit wir PHP 7.1 installieren können, müssen wir zum `apt-get` Quellen hinzufügen. Damit dies funktioniert brauche ich Python. Dies installier ich mit:
```
sudo apt-get install python-software-properties
sudo apt-get install software-properties-common
```

### 2.1.2 PPA hinzufügen

Nun fügen wir das PPA(Personal Package Archive) hinzu und updaten `apt-get`:
```
sudo add-apt-repository ppa:ondrej/php
sudo apt-get update
```

### 2.1.3 Was ist das richtige PHP

Es gibt viele verschiedene PHP Packete für jede Version. Diese kannst du die anzeigen lassen indem du:
```
apt-cache pkgnames | grep php7.1
```
eingibst.  
Nun solltest du folgendes erhalten:
```
php7.1-xml
php7.1-xsl
php7.1-mbstring
php7.1-readline
php7.1-zip
php7.1-mysql
php7.1-phpdbg
php7.1-interbase
php7.1-sybase
php7.1
php7.1-sqlite3
php7.1-tidy
php7.1-opcache
php7.1-pspell
php7.1-json
php7.1-xmlrpc
php7.1-curl
php7.1-ldap
php7.1-bz2
php7.1-cgi
php7.1-imap
php7.1-cli
php7.1-dba
php7.1-dev
php7.1-intl
php7.1-fpm
php7.1-recode
php7.1-odbc
php7.1-gmp
php7.1-common
php7.1-pgsql
php7.1-bcmath
php7.1-snmp
php7.1-soap
php7.1-mcrypt
php7.1-gd
php7.1-enchant
libapache2-mod-php7.1
libphp7.1-embed
```
Viel PHP kram, einiges sind Module einiges sind vollständige PHP versionen . Wir installieren an dieser stelle erstmal nichts, denn wir installieren erst wenn wir etwas bruchen. Da wir jetzt PHP noch nirgends einbinden müssen oder benutzen brauchen wir PHP auch noch nciht.

## 2.2 Webserver

Bevor irgendwas auf unserem Server erreichbar ist brauchen wir einen Webserver. Wir nehmen benutzen Nginx. Also installieren wir Nginx mit:
```
sudo apt-get install nginx
````
>Unsere Wahl des Webservers viel auf nginx. Welchen du nimmst sei dir überlassen, nur musst du beachten das eventuell einige teile des Setups dann nicht auf dich zutreffen

Wir wollen nun testen ob nginx funktioniert. Dazu erstellen wir einen Ordner:
```
mkdir /var/ww/playground/
```
Nun müssen wir auch eine `index.html`. 
```
vim /var/www/playground/index.html
```
```html
<html>
  <body>
    <p>Es Geht!</p>
  </body>
</html>
```
Nun müssen wir unserem Nginx configureren, damit er auch erkennt das wir 


nginx config
```
server {
    listen      80;
    server_name your-url.com;
    root        /var/www/playground/;
    index       index.html index.htm;

    # log files
    access_log  /var/log/nginx/ember.ene-mene-muh.de-access.log;
    error_log   /var/log/nginx/ember.ene-mene-muh.de/error.log;

    # ssl files
#    ssl on;i
#    keepalive_timeout   60;

    # proxy buffers
    proxy_buffers 16 64k;
    proxy_buffer_size 128k;

    ## default location ##
    location /test {
        include /etc/nginx/mime.types;
        try_files $uri $uri/ /index.html?/$request_uri;
    }

}
```
link to enable
```
sudo ln -s /etc/nginx/sites-available/example.com /etc/nginx/sites-enabled/
```

php-fpm config  
/etc/php/7.1/fpm/pool.d/file.conf

```
[playground.regiostart.com]

listen = /var/run/php7.1-fpm/php7.1-fpm-playground.sock
listen.backlog = -1
listen.owner = nginx
listen.group = www-data
listen.mode=0660

; Unix user/group of processes

user = (THE USERNAME OF THE USER THAT OWNS THE SITE FILES)
group = www-data

; Choose how the process manager will control the number of child processes.

pm = dynamic
pm.max_children = 75
pm.start_servers = 10
pm.min_spare_servers = 5
pm.max_spare_servers = 20
pm.max_requests = 500

; Pass environment variables

env[HOSTNAME] = $HOSTNAME
env[PATH] = /usr/local/bin:/usr/bin:/bin
env[TMP] = /tmp
env[TMPDIR] = /tmp
env[TEMP] = /tmp

; host-specific php ini settings here
; php_admin_value[open_basedir] = /var/www/DOMAINNAME/htdocs:/tmp
```

## HTTP Auth in nginx

```
sudo apt-get install apache2-utils
```

```
htpasswd -c /etc/nginx/.htpasswd exampleuser
```

```
server {
  listen       portnumber;
  server_name  ip_address;
  location / {
      root   /var/www/mywebsite.com;
      index  index.html index.htm;
      auth_basic "Restricted";                    #For Basic Auth
      auth_basic_user_file /etc/nginx/.htpasswd;  #For Basic Auth
  }
}
```

## MySQL 

```
sudo apt-get update
sudo apt-get upgrade
sudo apt-get install mysql-server-5.7
```