# How to setup Hallonachbarn API

## 1. On mac

### 1.1 Install dependencies

Wen need following packages 
```
brew install pkg-config
brew tap homebrew/science
brew install opencv
brew install graphicsmagick
```

### 1.2 The DB and filestrcture setup

Change into your desired working directory and clone the api into it.
Now you need to open a ssh tunnel for mongodb with 
```
ssh -fNg -L 27018:127.0.0.1:27017 www-data@192.168.168.40
```
If you need a password please contact an admin.  
Now we create a dump from the database via
```
mongodump --port 27018 --db hallonachbarn_cms
```

Please choose another directory and not your working directory, like your `~/Downloads` directory.  
Now you run in your directory where the database was dumped 
```
mongorestore dump/
```
Now we need a directory for our images. So we create following path in our working directory:
```
./images
```
There we paste all our images with:
```
scp -r www-data@192.168.168.40:/var/www/web/hallo-nachbarn/images ./images
```
If you choose you may make this an development system if you create `./images/original`and copy all the files into it.

### 2.3 Elasticsearch setup and configurarion

Open [this](https://www.elastic.co/de/downloads/past-releases/elasticsearch-2-4-0) link and download the package of your choice. After this is done move extract the package and move the extracted directory next to your applicatin as a sibling.  Now open `./elasticsearch-2.4/config/elasticsearch.yml`.  
At the end of the document add: `http.port:9201`  
Now run elasticsearch with 
```
./elasticsearch-2.4/bin/elasticsearch
```

### 2.4 Filling our application with data

So now we need to populate the DB and elastic search with the help of 2 scripts:
```
scripts/populate-media-db.js
```
and
```
scripts/elasticsearch-import
```

Now try to execute `app.js`